//
//  YHVisaRenewalItemDetailType.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation
import AttributedString

enum YHVisaRenewalItemDetailType {
    case sectionHeader(_ title: String, _ actionTitle: String? = nil, _ action: (() -> Void)? = nil)
    case tips(_ detail: ASAttributedString)
    case residenceAction(_ title: String, _ status: YHVisaRenewalPresenceStatus, _ cellType: YHResignRoundCellType = .mid, _ action: (() -> Void)? = nil)
    case payMethodUrl(_ title: String, _ tips: String, _ url: String, _ action: (() -> Void)? = nil)
    case payMethodQrcode(_ title: String, _ tips: String, _ qrcodeUrl: String)
    case subHeader(_ title: String, _ status: YHVisaRenewalPaymentStatus)
    case subInfo(_ title: String, _ detail: String, _ actionTitle: String? = nil, _ cellType: YHResignRoundCellType = .mid, _ defaultMargin: CGFloat? = nil, _ showBottomLine: Bool = false, _ action: (() -> Void)? = nil)
    case subContent(_ title: String, _ detail: String, _ actionTitle: String? = nil, _ cellType: YHResignRoundCellType = .mid, _ action: (() -> Void)? = nil)
    case subRemark(_ remark: String)
    case occupyingSpace
}

enum YHVisaRenewalInfoItemDetailType {
    case sectionHeader(_ title: String, _ actionTitle: String? = nil, _ action: (() -> Void)? = nil)
    case payMethodUrl(_ title: String, _ tips: String, _ url: String, _ action: (() -> Void)? = nil)
    case payMethodQrcode(_ title: String, _ tips: String, _ qrcodeUrl: String)
    case subHeader(_ title: String)
    case subInfo(_ title: String, _ detail: String, _ actionTitle: String? = nil, _ cellType: YHResignRoundCellType = .mid, _ defaultMargin: CGFloat? = nil, _ showBottomLine: Bool = false, _ action: (() -> Void)? = nil)
    case subContent(_ title: String, _ detail: String, _ actionTitle: String? = nil, _ cellType: YHResignRoundCellType = .mid, _ action: (() -> Void)? = nil)
    case occupyingSpace
}
