//
//  YHVisaRenewalPresenceStatus.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

enum YHVisaRenewalPresenceStatus: Int {
    // 暂未获批 确认在港 已确认在港
    case approvalPending = 0
    case confirmingPresence = 1
    case confirmedPresence = 2
    
    var title: String {
        switch self {
        case .approvalPending:
            return "暂未获批"
        case .confirmingPresence:
            return "确认在港"
        case .confirmedPresence:
            return "已确认在港"
        }
    }
    
    var titleColor: UIColor? {
        switch self {
        case .approvalPending:
            return .mainTextColor30
        case .confirmingPresence:
            return UIColor(hexString: "#FFFFFF")
        case .confirmedPresence:
            return .yhGreenColor
        }
    }
    
    var bgColor: UIColor? {
        switch self {
        case .approvalPending:
            return UIColor(hexString: "#F4F6FA")
        case .confirmingPresence:
            return .brandMainColor
        case .confirmedPresence:
            return .clear
        }
    }
}
