//
//  YHHKVisaRenewalPaymentStepView.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKVisaRenewalPaymentStepView: UIView {
    private let stepNames: [String] = ["确认在港", "复制档案号", "官网缴费", "查看签证"]
    private let stepLabelHeight: CGFloat = 18
    
    private lazy var firstStepLabel: UILabel = {
        return getStepLabel("1")
    }()
    
    private lazy var secondStepLabel: UILabel = {
        return getStepLabel("2")
    }()
    
    private lazy var thirdStepLabel: UILabel = {
        return getStepLabel("3")
    }()
    
    private lazy var fourthStepLabel: UILabel = {
        return getStepLabel("4")
    }()
    
    private lazy var firstStepNameLabel: UILabel = {
        return getStepNameLabel(stepNames[0])
    }()
    
    private lazy var secondStepNameLabel: UILabel = {
        return getStepNameLabel(stepNames[1])
    }()
    
    private lazy var thirdStepNameLabel: UILabel = {
        return getStepNameLabel(stepNames[2])
    }()
    
    private lazy var fourthStepNameLabel: UILabel = {
        return getStepNameLabel(stepNames[3])
    }()
    
    private lazy var firstDashLine: YHDashLineView = {
        return getDashLineView()
    }()
    
    private lazy var secondDashLine: YHDashLineView = {
        return getDashLineView()
    }()
    
    private lazy var thirdDashLine: YHDashLineView = {
        return getDashLineView()
    }()
        
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupViews()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

}

extension YHHKVisaRenewalPaymentStepView {
    
    private func setupViews() {
        backgroundColor = .white
        addSubviews([firstStepLabel, secondStepLabel, thirdStepLabel, fourthStepLabel])
        addSubviews([firstDashLine, secondDashLine, thirdDashLine])
        addSubviews([firstStepNameLabel, secondStepNameLabel, thirdStepNameLabel, fourthStepNameLabel])
        firstStepLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.left.equalToSuperview().offset(50)
            make.width.height.equalTo(stepLabelHeight)
        }
        fourthStepLabel.snp.makeConstraints { make in
            make.top.equalTo(firstStepLabel.snp.top)
            make.right.equalToSuperview().offset(-50)
            make.width.height.equalTo(stepLabelHeight)
        }
        secondStepLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.width.height.equalTo(stepLabelHeight)
        }
        thirdStepLabel.snp.makeConstraints { make in
            make.top.equalTo(firstStepLabel.snp.top)
            make.width.height.equalTo(stepLabelHeight)
        }
        firstDashLine.snp.makeConstraints { make in
            make.left.equalTo(firstStepLabel.snp.right).offset(8)
            make.right.equalTo(secondStepLabel.snp.left).offset(-8)
            make.height.equalTo(1)
            make.centerY.equalTo(firstStepLabel)
        }
        
        secondDashLine.snp.makeConstraints { make in
            make.left.equalTo(secondStepLabel.snp.right).offset(8)
            make.right.equalTo(thirdStepLabel.snp.left).offset(-8)
            make.width.equalTo(firstDashLine)
            make.height.equalTo(1)
            make.centerY.equalTo(firstStepLabel)
        }
        
        thirdDashLine.snp.makeConstraints { make in
            make.left.equalTo(thirdStepLabel.snp.right).offset(8)
            make.right.equalTo(fourthStepLabel.snp.left).offset(-8)
            make.width.equalTo(firstDashLine)
            make.height.equalTo(1)
            make.centerY.equalTo(firstStepLabel)
        }
        
        firstStepNameLabel.snp.makeConstraints { make in
            make.top.equalTo(firstStepLabel.snp.bottom).offset(6)
            make.centerX.equalTo(firstStepLabel.snp.centerX)
            make.bottom.equalToSuperview().offset(-16)
        }
        
        secondStepNameLabel.snp.makeConstraints { make in
            make.top.equalTo(secondStepLabel.snp.bottom).offset(6)
            make.centerX.equalTo(secondStepLabel.snp.centerX)
            make.bottom.equalToSuperview().offset(-16)
            make.left.greaterThanOrEqualTo(firstStepNameLabel.snp.right).offset(6)
        }
        
        thirdStepNameLabel.snp.makeConstraints { make in
            make.top.equalTo(thirdStepLabel.snp.bottom).offset(6)
            make.centerX.equalTo(thirdStepLabel.snp.centerX)
            make.bottom.equalToSuperview().offset(-16)
            make.left.greaterThanOrEqualTo(secondStepNameLabel.snp.right).offset(6)
        }
        
        fourthStepNameLabel.snp.makeConstraints { make in
            make.top.equalTo(fourthStepLabel.snp.bottom).offset(6)
            make.centerX.equalTo(fourthStepLabel.snp.centerX)
            make.bottom.equalToSuperview().offset(-16)
            make.left.greaterThanOrEqualTo(thirdStepNameLabel.snp.right).offset(6)
        }
        
    }
    
    private func getStepLabel(_ title: String) -> UILabel {
        let label = UILabel()
        label.font = UIFont(name: "DINAlternate-Bold", size: 12)
        label.textColor = .brandMainColor
        label.layer.cornerRadius = stepLabelHeight / 2.0
        label.clipsToBounds = true
        label.layer.borderWidth = 1
        label.layer.borderColor = UIColor.brandMainColor16.cgColor
        label.text = title
        label.textAlignment = .center
        return label
    }
    
    private func getStepNameLabel(_ title: String) -> UILabel {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = .mainTextColor
        label.text = title
        return label
    }
    
    private func getDashLineView() -> YHDashLineView {
        let view = YHDashLineView(strokeColor: UIColor.brandMainColor16.cgColor, lineWidth: 1, lineDashPattern: [2, 2])
        return view
    }
}
