//
//  YHVisaRenewalGuideTipsCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHVisaRenewalGuideTipsCell: UITableViewCell {
    static let cellReuseIdentifier = "YHVisaRenewalGuideTipsCell"
    
    private lazy var iconView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor
        return view
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_B(ofSize: 14)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 13)
        label.textColor = .mainTextColor70
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var subContainerView: YHBaseDynamicCornerRadiusView = {
        let view = YHBaseDynamicCornerRadiusView(cornerRadius: 6, corner: .allCorners)
        view.backgroundColor = .contentBkgColor
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, detail: ASAttributedString) {
        infoTitleLabel.text = title
        infoDetailLabel.attributed.text = detail
    }

}

extension YHVisaRenewalGuideTipsCell {
    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.addSubview(subContainerView)
        subContainerView.addSubview(iconView)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.setContentHuggingPriority(.defaultLow, for: .vertical)
        subContainerView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(20)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalToSuperview()
        }
        
        iconView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(18)
            make.left.equalToSuperview()
            make.width.equalTo(4)
            make.height.equalTo(14)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.centerY.equalTo(iconView)
            make.left.equalTo(iconView.snp.right).offset(12)
            make.right.lessThanOrEqualToSuperview().offset(-16)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.top.equalTo(infoTitleLabel.snp.bottom).offset(12)
            make.left.equalTo(infoTitleLabel)
            make.right.lessThanOrEqualToSuperview().offset(-16)
            make.bottom.equalToSuperview().offset(-16)
        }
    }
}
