//
//  YHVisaRenewalPayContentCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVisaRenewalPayContentCell: YHVisaRenewalPayInfoBaseCell {

    static let cellReuseIdentifier = "YHVisaRenewalPayContentCell"
    
    var rightButtonEvent: (() -> Void)?
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 13)
        label.textColor = .mainTextColor70
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 13)
        label.textColor = UIColor(hexString: "#222222")
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var rightButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setTitleColor(.mainTextColor, for: .normal)
        button.titleLabel?.font = .PFSC_M(ofSize: 10)
        button.backgroundColor = .separatorColor
        button.layer.cornerRadius = 8
        button.clipsToBounds = true
        button.addTarget(self, action: #selector(rightButtonClicked), for: .touchUpInside)
        return button
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, detail: String, rightButtonTitle: String? = nil, cellType: YHResignRoundCellType = .mid) {
        infoTitleLabel.text = title
        infoDetailLabel.text = detail
        updateInnerCellCorner(cellType)
        let bottomMargin = cellType == .bottom ? 16 : 12
        bottomLineView.isHidden = cellType == .bottom
        infoDetailLabel.snp.remakeConstraints { make in
            make.top.equalTo(infoTitleLabel.snp.bottom).offset(12)
            make.right.lessThanOrEqualToSuperview().offset(-16)
            make.left.equalTo(infoTitleLabel)
            make.bottom.equalToSuperview().offset(-bottomMargin)
        }
        if let rightButtonTitle = rightButtonTitle, rightButtonTitle.count > 0 {
            rightButton.setTitle(rightButtonTitle, for: .normal)
            rightButton.isHidden = false
        } else {
            rightButton.setTitle(nil, for: .normal)
            rightButton.isHidden = true
        }
    }
}

extension YHVisaRenewalPayContentCell {
    @objc private func rightButtonClicked() {
        rightButtonEvent?()
    }
    
    private func setupUI() {
        updateInnerCellCorner(.mid)
        innerContainerView.addSubview(rightButton)
        innerContainerView.addSubview(infoTitleLabel)
        innerContainerView.addSubview(infoDetailLabel)
        innerContainerView.addSubview(bottomLineView)
        rightButton.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoTitleLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        
        bottomLineView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.bottom.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.top.equalToSuperview().offset(12)
        }
        
        rightButton.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-16)
            make.width.equalTo(36)
            make.height.equalTo(18)
            make.centerY.equalTo(infoTitleLabel)
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(12)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.top.equalTo(infoTitleLabel.snp.bottom).offset(12)
            make.right.lessThanOrEqualToSuperview().offset(-16)
            make.left.equalTo(infoTitleLabel)
            make.bottom.equalToSuperview().offset(-12)
        }
    }
}
