//
//  YHVisaRenewalPayInfoBaseCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVisaRenewalPayInfoBaseCell: YHResignDocumentCell {

    lazy var innerContainerView: YHBaseDynamicCornerRadiusView = {
        let view = YHBaseDynamicCornerRadiusView(cornerRadius: 6, corner: .none)
        view.backgroundColor = .contentBkgColor
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func updateInnerCellCorner(_ cellType: YHResignRoundCellType) {
        switch cellType {
        case .top:
            innerContainerView.corner = [.topLeft, .topRight]
        case .mid:
            innerContainerView.corner = .none
        case .bottom:
            innerContainerView.corner = [.bottomLeft, .bottomRight]
        case .single:
            innerContainerView.corner = .allCorners
        }
    }
}

extension YHVisaRenewalPayInfoBaseCell {
    private func setupUI() {
        subContainerView.radius = 6
        updateCellCorner(.mid)
        subContainerView.addSubview(innerContainerView)
        innerContainerView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
        }
    }
}
