//
//  YHVisaRenewalPayMethodUrlCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHVisaRenewalPayMethodUrlCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHVisaRenewalPayMethodUrlCell"
    
    var urlClicked: ((String) -> Void)?
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 14)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var infoTipsLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = .mainTextColor50
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var bottomContainerView: YHBaseDynamicCornerRadiusView = {
        let view = YHBaseDynamicCornerRadiusView(cornerRadius: 4, corner: .allCorners)
        view.backgroundColor = .contentBkgColor
        return view
    }()
    
    private lazy var urlLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = .brandMainColor
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, tips: String, url: String) {
        infoTitleLabel.text = title
        infoTipsLabel.text = tips
        
        let attStr = ASAttributedString.init(string: url, .underline(.init(rawValue: 1)), .action { [weak self] in
            self?.urlClicked?(url)
        })
        urlLabel.attributed.text = attStr
    }
}

extension YHVisaRenewalPayMethodUrlCell {
    private func setupUI() {
        subContainerView.radius = 6
        updateCellCorner(.mid)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoTipsLabel)
        subContainerView.addSubview(bottomContainerView)
        subContainerView.addSubview(bottomLineView)
        bottomContainerView.addSubview(urlLabel)
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview()
            make.right.lessThanOrEqualToSuperview().offset(-18)
        }
        
        infoTipsLabel.snp.makeConstraints { make in
            make.left.equalTo(infoTitleLabel.snp.left)
            make.top.equalTo(infoTitleLabel.snp.bottom).offset(6)
            make.right.lessThanOrEqualToSuperview().offset(-18)
        }
        
        bottomContainerView.snp.makeConstraints { make in
            make.top.equalTo(infoTipsLabel.snp.bottom).offset(12)
            make.left.equalTo(infoTitleLabel.snp.left)
            make.right.equalToSuperview().offset(-18)
            make.bottom.equalToSuperview().offset(-18)
        }
        
        urlLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-16)
        }
        
        bottomLineView.snp.makeConstraints { make in
            make.left.equalTo(infoTitleLabel.snp.left)
            make.right.equalTo(bottomContainerView.snp.right)
            make.bottom.equalToSuperview()
            make.height.equalTo(0.5)
        }
    }
}
