//
//  YHVisaRenewalSectionHeaderCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVisaRenewalSectionHeaderCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHVisaRenewalSectionHeaderCell"
    
    var rightButtonEvent: (() -> Void)?
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_B(ofSize: 17)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var rightButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setTitleColor(.brandMainColor, for: .normal)
        button.titleLabel?.font = .PFSC_R(ofSize: 12)
        button.addTarget(self, action: #selector(rightButtonClicked), for: .touchUpInside)
        return button
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, buttonTitle: String? = nil) {
        infoTitleLabel.text = title
        guard let buttonTitle = buttonTitle, buttonTitle.count > 0 else {
            rightButton.setTitle(nil, for: .normal)
            rightButton.isHidden = true
            return
        }
        rightButton.isHidden = false
        rightButton.setTitle(buttonTitle, for: .normal)
    }
}

extension YHVisaRenewalSectionHeaderCell {
    @objc private func rightButtonClicked() {
        rightButtonEvent?()
    }
    
    private func setupUI() {
        subContainerView.radius = 6
        updateCellCorner(.top)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(rightButton)
        subContainerView.addSubview(bottomLineView)
        infoTitleLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        rightButton.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-12)
        }
        
        rightButton.snp.makeConstraints { make in
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(6)
            make.centerY.equalTo(infoTitleLabel)
            make.right.equalToSuperview().offset(-18)
        }
        
        bottomLineView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(0.5)
        }
    }
}
