//
//  YHVisaRenewalTipsCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHVisaRenewalTipsCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHVisaRenewalTipsCell"

    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = .mainTextColor50
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(detail: ASAttributedString) {
        infoDetailLabel.attributed.text = detail
    }

}

extension YHVisaRenewalTipsCell {
    private func setupUI() {
        subContainerView.radius = 6
        updateCellCorner(.mid)
        subContainerView.addSubview(infoDetailLabel)
        infoDetailLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(12)
            make.bottom.equalToSuperview().offset(-12)
            make.right.lessThanOrEqualToSuperview().offset(-18)
        }
    }
}
