//
//  YHHKVisaRenewalPaymentViewModel.swift
//  
//
//  Created by alexzzw on 2024/10/12.
//

import UIKit

class YHHKVisaRenewalPaymentViewModel: YHBaseViewModel {
    
    func getPaymentList(orderId: Int, renewalId: Int, callback: @escaping (_ paymentListModel: YHHKVisaRenewalPaymentList?, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["order_id": orderId, "renewal_id": renewalId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignVisa.paymentList
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHHKVisaRenewalPaymentList.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                callback(resultModel, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }
            
        } failBlock: { err in
            callback(nil, err)
        }
    }
    
    func confirmInHK(orderId: Int, renewalId: Int, uid: Int, type: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void ) {
        // 用户类型 主申请人-applicant 配偶-spouse 孩子-child 母亲-mother 父亲-father 兄弟姐妹-brother

        let params: [String: Any] = ["order_id": orderId,
                                      "renewal_id": renewalId,
                                      "uid": uid,
                                      "type": type]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignVisa.confirmInHK
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func getPaymentInfo(id: Int, isEdit: Int, callBackBlock: @escaping (_ paymentListModel: YHHKVisaRenewalPaymentInfoList?, _ error: YHErrorModel?) -> Void ) {
        let params: [String: Any] = ["id": id,
                                      "is_edit": isEdit
                                     ]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignVisa.paymentInfo
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHHKVisaRenewalPaymentInfoList.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(nil, err)
                    return
                }
                callBackBlock(resultModel, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(nil, err)
            }
        } failBlock: { err in
            callBackBlock(nil, err)
        }
    }
}
