//
//  YHLookResignAlertView.swift
//  galaxy
//
//  Created by EDY on 2024/10/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHLookResignAlertView: UIView {
    var dismissBlock: (() -> Void)?
    var centerView: UIView!
    var titleLabel: UILabel!
    var messageLabel: UILabel!
    var closeButton: UIButton!
    var sureButton: UIButton!
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(497)
        }
        
        titleLabel = {
            let label = UILabel()
            label.text = "缴费须知"
            label.font = UIFont.PFSC_M(ofSize: 26)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(23)
            make.height.equalTo(30)
            make.right.equalTo(-20)
            make.left.equalTo(20)
        }
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.setImage(UIImage(named: "service_card_close"), for: .normal)
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.height.equalTo(24)
            make.width.equalTo(24)
            make.top.equalTo(26)
        }
        
        sureButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("我已阅读并同意", for: .normal)
            button.setTitleColor(UIColor.white, for: .normal)
            button.backgroundColor = UIColor.brandMainColor
            button.addTarget(self, action: #selector(sure), for: .touchUpInside)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            return button
        }()
        centerView.addSubview(sureButton)
        sureButton.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.left.equalTo(20)
            make.height.equalTo(48)
            make.bottom.equalTo(-42)
        }
        
        messageLabel = {
            let label = UILabel()
            label.numberOfLines = 0
            let a = ASAttributedString.init("根据港府政策，获批后缴费领取新电子签证时，申请人应身在香港；", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor70))
            let b = ASAttributedString.init("请勿在香港境外点击缴费链接", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.failColor))
            let c = ASAttributedString.init("，避免签证被锁，导致需重发签证，对您造成时间、费用成本损失，甚至身份失效\n\n建议入境香港后，远离海关，", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor70))
            let d = ASAttributedString.init("至少2个小时后再进行缴费", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.failColor))
            let e = ASAttributedString.init("，避免香港海关系统还未识别到入境记录!", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor70))
            label.attributed.text = a+b+c+d+e
            return label
        }()
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.top.equalTo(68)
            make.left.equalTo(20)
            make.right.equalTo(-20)
        }
        
        centerView.layoutIfNeeded()
        let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
        let path = UIBezierPath(roundedRect: bounds, byRoundingCorners: corner, cornerRadii: CGSize(width: kCornerRadius6, height: kCornerRadius6))
        let layer = CAShapeLayer()
        layer.frame = centerView.bounds
        layer.path = path.cgPath
        centerView.layer.mask = layer
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        dismiss()
    }
    
    static func show(dismiss: (() -> Void)? = nil) {
        let view = YHLookResignAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.dismissBlock = dismiss
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
    
    @objc func sure() {
        if self.dismissBlock != nil {
            self.dismissBlock!()
        }
        dismiss()
    }
}

extension YHLookResignAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
