//
//  YHLookResignResultPrivateView.swift
//  galaxy
//
//  Created by EDY on 2024/10/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHLookResignResultPrivateView: UIView {
    var agreeButton: UIButton!
    var messageLabel: UILabel!
    var isAgree: Bool = false {
        didSet {
            agreeButton.isSelected = isAgree
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = .white
        agreeButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "login_privacy_disagree_glay"), for: .normal)
            button.setBackgroundImage(UIImage(named: "login_privacy_agree"), for: .selected)

            button.addTarget(self, action: #selector(agreeClick), for: .touchUpInside)
            return button
        }()
        addSubview(agreeButton)
        agreeButton.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(16)
            make.height.equalTo(13)
            make.width.equalTo(13)
        }
        
        messageLabel = {
            let label = UILabel()
            let a = ASAttributedString.init("已阅读并同意", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor.mainTextColor50))
            let c = ASAttributedString.init("缴费须知", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor.brandMainColor), .underline(.single), .action {
                // 跳转引导
                self.alert()
            })
            let e = ASAttributedString.init("，请勿在香港境外点击缴费链接", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor.mainTextColor50))
            label.attributed.text = a+c+e
            return label
        }()
        addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(agreeButton.snp.right).offset(6)
            make.centerY.equalToSuperview()
            make.height.equalTo(20)
        }
        
        agreeButton.YH_clickEdgeInsets = UIEdgeInsets(top: 50, left: 50, bottom: 50, right: 50)

    }
    
    @objc func agreeClick() {
        agreeButton.isSelected = !agreeButton.isSelected
        isAgree = agreeButton.isSelected
    }
    
    func alert() {
        YHLookResignAlertView.show { [weak self] in
            guard let self = self else { return }
            self.agreeButton.isSelected = true
            self.isAgree = self.agreeButton.isSelected
        }
    }
}
