//
//  YHLookResignResultStateThreePeopleTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/10/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHLookResignResultStateThreePeopleTableViewCell: UITableViewCell {
    static let cellReuseIdentifier = "YHLookResignResultStateThreePeopleTableViewCell"

    typealias ExperienceListBlock = (_ model: YHResignUploadDocModel, _ section: Int) -> Void
    var clickBlock: ExperienceListBlock?
    var centerView: UIView!
    var flagView: UIView!
    var titleLabel: UILabel!
    var peopleLabel: UILabel!
    var peopleValueLabel: UILabel!
    var docLabel: UILabel!
    var docValueLabel: UILabel!
    var lineView: UIView!
    var title: String = "" {
        didSet {
            titleLabel.text = title
        }
    }
    var dataSource: YHLookResignResultDataDataModel? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(0)
            make.bottom.equalTo(0)
        }
    
        flagView = {
            let view = UIView()
            view.backgroundColor = UIColor.brandMainColor
            return view
        }()
        centerView.addSubview(flagView)
        flagView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.top.equalTo(18)
            make.height.equalTo(16)
            make.width.equalTo(4)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 15)
            label.text = "第一批"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(16)
            make.height.equalTo(20)
            make.right.equalTo(-20)
        }
    
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(-4)
            make.height.equalTo(0.5)
        }
        
        peopleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.text = "获批时间："
            label.textColor = UIColor.mainTextColor50
            return label
        }()
        centerView.addSubview(peopleLabel)
        peopleLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(52)
            make.height.equalTo(20)
            make.right.equalTo(-18)
        }
        
        peopleValueLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.text = "2024年06月01日"
            label.textColor = UIColor.mainTextColor50
            label.textAlignment = .right
            return label
        }()
        centerView.addSubview(peopleValueLabel)
        peopleValueLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(52)
            make.height.equalTo(20)
            make.right.equalTo(-16)
        }
        
        docLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.text = "缴费截止时间："
            label.textColor = UIColor.mainTextColor50
            return label
        }()
        centerView.addSubview(docLabel)
        docLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(84)
            make.height.equalTo(20)
            make.right.equalTo(-16)
        }
        
        docValueLabel = {
            let label = UILabel()
            label.textColor = UIColor.mainTextColor50
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.text = "2024年06月01日"
            label.textAlignment = .right
            return label
        }()
        centerView.addSubview(docValueLabel)
        docValueLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(84)
            make.height.equalTo(20)
            make.right.equalTo(-16)
        }
        
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        var names = "： "
        var i = 0
        for item in dataSource.users {
            if i == 0 {
                names += item
            } else {
                names = names + "、" + item
            }
            i += 1
        }
        titleLabel.text = title + names
        peopleValueLabel.text = dataSource.result_date
        docValueLabel.text = dataSource.pay_deadline
    }

}
