//
//  YHLookResignResultStateTwoTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/10/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHLookResignResultStateTwoTableViewCell: UITableViewCell {
    static let cellReuseIdentifier = "YHLookResignResultStateTwoTableViewCell"

    typealias ExperienceListBlock = (_ model: YHResignUploadDocModel, _ section: Int) -> Void
    var clickBlock: ExperienceListBlock?
    var centerView: UIView!
    var flagView: UIView!
    var flagImageView: UIImageView!
    var flagLabel: UILabel!
    var mainItemView: UIView!
    var state: Int = 0
    var dataSource: [YHLookResignResultDataLettersModel]? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(0)
            make.bottom.equalTo(0)
        }
        
        flagView = {
            let view = UIView()
            view.backgroundColor = UIColor(hex: 0xfff5eb)
            view.layer.cornerRadius = kCornerRadius3
            return view
        }()
        centerView.addSubview(flagView)
        flagView.snp.makeConstraints { make in
            make.left.top.equalTo(12)
            make.right.equalTo(-12)
            make.height.equalTo(60)
        }
        
        flagImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "resign_upload_doc_flag")
            return view
        }()
        flagView.addSubview(flagImageView)
        flagImageView.snp.makeConstraints { make in
            make.left.equalTo(12)
            make.top.equalTo(15)
            make.width.height.equalTo(14)
        }
        
        flagLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 13)
            label.text = "如无及时递交，可能导致身份丢失！请及时查看补件清单并上传资料！"
            label.textColor = UIColor(hex: 0xff8000)
            label.numberOfLines = 0
            return label
        }()
        flagView.addSubview(flagLabel)
        flagLabel.snp.makeConstraints { make in
            make.left.equalTo(34)
            make.top.equalTo(12)
            make.right.equalTo(-12)
        }
        
        mainItemView = {
            let view = UIView()
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(72)
        }
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        mainItemView.removeSubviews()
        if dataSource.count == 1 {
            let view = YHLookResignResultItemView(frame: .zero)
            view.state = state
            view.dataSource = dataSource.first
            mainItemView.addSubview(view)
            view.snp.makeConstraints { make in
                make.centerX.equalToSuperview()
                make.top.equalTo(20)
                make.width.equalTo(197)
                make.height.equalTo(142)
            }
        } else {
            var count = 0
            for item in dataSource {
                let y: Int = count / 2
                let x: Int = count % 2
                let view = YHLookResignResultItemView(frame: .zero)
                view.state = state
                view.dataSource = dataSource.first
                mainItemView.addSubview(view)
                view.snp.makeConstraints { make in
                    if x == 0 {
                        make.left.equalTo(20)
                    } else {
                        make.right.equalTo(-20)
                    }
                    make.top.equalTo(y * 116 + 15)
                    make.width.equalTo(140.fix)
                    make.height.equalTo(101)
                }
                count += 1
            }
        }
    }
}

class YHLookResignResultItemView: UIImageView {
    var dataSource: YHLookResignResultDataLettersModel? {
        didSet {
            self.titleLabel.text = dataSource?.user
        }
    }
    var state: Int? {
        didSet {
            if state == 0 {
                self.image = UIImage(named: "look_resign_result_mail_two")
                self.titleLabel.textColor = UIColor(hex: 0xb75e24).withAlphaComponent(0.6)
            } else if state == 1 {
                self.image = UIImage(named: "look_resign_result_mail_three")
                self.titleLabel.textColor = UIColor(hex: 0xe97900)

            } else {
                self.image = UIImage(named: "look_resign_result_mail_four")
                self.titleLabel.textColor = UIColor(hex: 0xb75e24)
            }
        }
    }
    var titleLabel: UILabel!
    
    lazy var previewFileTool: YHFilePreviewTool = {
        let tool = YHFilePreviewTool(targetVC: UIViewController.current)
       return tool
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.isUserInteractionEnabled = true
        createUI()
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.image = UIImage(named: "look_resign_result_mail_two")
        titleLabel = {
            let label = UILabel()
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .center
            label.font = UIFont.PFSC_B(ofSize: 17)
            label.text = "欧阳唯一欧阳"
            label.numberOfLines = 0
            return label
        }()
        
        self.addSubview(titleLabel)
        
        titleLabel.snp.makeConstraints { make in
            make.right.equalTo(-10)
            make.left.equalTo(10)
            make.top.equalTo(20)
            make.bottom.equalTo(self.snp.centerY)
        }
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        if state == 1 {
            let viewModel = YHBaseViewModel()
            viewModel.getRealUsefulUrl(dataSource?.result_file ?? "") { success in
                self.previewFileTool.openXLSXRemoteFile(urlString: success, fileName: "")
            }
        } else if dataSource?.confirm_in_hk == 1 {
            let viewModel = YHBaseViewModel()
            viewModel.getRealUsefulUrl(dataSource?.result_file ?? "") { success in
                self.previewFileTool.openXLSXRemoteFile(urlString: success, fileName: "")
            }
        }
    }
}

extension YHLookResignResultItemView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
