//
//  YHResignCertificateListViewController.swift
//  galaxy
//
//  Created by EDY on 2024/9/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignCertificateListViewController: YHBaseViewController {
    var tableView: UITableView!
    var orderId: Int = 0
    var viewModel = YHResignCertificateListViewModel()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navTitle = "续签证件管理"
        gk_navBackgroundColor = .white
        gk_navBarAlpha = 1.0
        setView()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        getData()
    }
    
    func getData() {
        viewModel.getResignCertificateList(orderId: orderId) {[weak self] _, _ in
            guard let self = self else { return }
            self.tableView.reloadData()
        }
    }
    
    func setView() {
        tableView = {
            let tableView = UITableView(frame: .zero, style: .plain)
            tableView.contentInsetAdjustmentBehavior = .never
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.showsVerticalScrollIndicator = false
            tableView.showsHorizontalScrollIndicator = false
            tableView.register(cellWithClass: YHResignCertificateListTableViewCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar + 8)
            make.left.right.equalTo(view)
            make.bottom.equalTo(-k_Height_safeAreaInsetsBottom())
        }
        
    }
    
}

extension YHResignCertificateListViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 4
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHResignCertificateListTableViewCell.self)
        cell.index = indexPath.row
        var model: [YHResignCertificateModel] = []
        if indexPath.row == 0 {
            model = self.viewModel.mainModel.TRAVEL
            cell.titleLabel.text = "旅行证件（港澳通行证/护照）"
        }
        if indexPath.row == 1 {
            model = self.viewModel.mainModel.E_VISA
            cell.titleLabel.text = "最新一次电子签证"
        }
        if indexPath.row == 2 {
            model = self.viewModel.mainModel.HK_ID_CARD
            cell.titleLabel.text = "香港身份证"
        }
        if indexPath.row == 3 {
            model = self.viewModel.mainModel.SMALL_WHITE_BAR
            cell.titleLabel.text = "最新一次小白条"
        }
        if model.count == 0 {
            cell.isHidden = true
        } else {
            cell.isHidden = false
        }
        cell.dataSource = model
        cell.clickBlock = { [weak self] model in
            guard let self = self else { return }
            if indexPath.row == 0 {
                if model.cert_type == "PASS_PORT" {
                    let vc = YHResignCertificateDetailPassPortViewController()
                    vc.cerId = model.id
                    self.navigationController?.pushViewController(vc)
                } else {
                    let vc = YHResignCertificateDetailHkViewController()
                    vc.cerId = model.id
                    self.navigationController?.pushViewController(vc)
                }
            }
            if indexPath.row == 1 {
                let vc = YHResignCertificateDetailEVisaViewController()
                vc.data = model
                self.navigationController?.pushViewController(vc)
            }
            if indexPath.row == 2 {
                if model.age < 11 {
                    return
                }
                let vc = YHResignCertificateDetailViewController()
                vc.detailType = .HongKongCard
                vc.dataModel = model
                self.navigationController?.pushViewController(vc)
            }
            if indexPath.row == 3 {
                let vc = YHResignCertificateDetailViewController()
                vc.detailType = .SmallWhiteNote
                vc.dataModel = model
                self.navigationController?.pushViewController(vc)
            }
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        var count = 0
        if indexPath.row == 0 {
            count = self.viewModel.mainModel.TRAVEL.count
        }
        if indexPath.row == 1 {
            count = self.viewModel.mainModel.E_VISA.count
        }
        if indexPath.row == 2 {
            count = self.viewModel.mainModel.HK_ID_CARD.count
        }
        if indexPath.row == 3 {
            count = self.viewModel.mainModel.SMALL_WHITE_BAR.count
        }
        if count == 0 {
            return 0
        }
        return CGFloat(68 + count * 52)
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
       
    }
    
}
