//
//  YHResignCertificateEvisaTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/9/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignCertificateEvisaTableViewCell: UITableViewCell {
    typealias ResignCertificateBlock = (_ model: YHResignCertificateModel) -> Void
    var clickBlock: ResignCertificateBlock?
    typealias ExperienceListBlock = (_ model: YHWorkExperienceFileModel, _ type: YHWorkFileClickType) -> Void
    var experienceListBlock: ExperienceListBlock?
    typealias NewFileBlock = () -> Void
    var newFileBlock: NewFileBlock?
    
    var centerView: UIView!
    var titleLabel: UILabel!
    var lineView: UIView!
    var itemView: YHWorkFileItemView!
    var bottomView: YHWorkItemAddView!
    
    var dataSource: [YHWorkExperienceFileModel]? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(16)
            make.bottom.equalToSuperview()
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.text = "*卢华臣的电子签证"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.right.equalTo(-20)
        }
        
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(0.5)
            make.top.equalTo(51.5)
        }
        
        itemView = {
            let view = YHWorkFileItemView()
            view.block = {[weak self] model, type in
                guard let self = self else { return }
                if let block = self.experienceListBlock {
                    block(model, type)
                }
            }
            return view
        }()
        centerView.addSubview(itemView)
        itemView.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.right.equalToSuperview()
            make.height.equalTo(74)
            make.bottom.equalToSuperview()
        }
        
        bottomView = {
            let view = YHWorkItemAddView()
            view.addBtn.setTitle("上传".local, for: .normal)
            view.clickBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.newFileBlock {
                    block()
                }
            }
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.left.equalTo(18)
            make.height.equalTo(45)
            make.bottom.equalTo(-16)
        }
    }
    
    func updateAllViews() {
        guard let model = dataSource, model.count != 0 else {
            bottomView.isHidden = false
            itemView.isHidden = true
            return
        }
        itemView.dataSource = model.first
        bottomView.isHidden = true
        itemView.isHidden = false
    }
}
