//
//  YHResignCertificateListTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/9/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignCertificateListTableViewCell: UITableViewCell {
    typealias ResignCertificateBlock = (_ model: YHResignCertificateModel) -> Void
    var clickBlock: ResignCertificateBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var mainItemView: UIView!
    var lineView: UIView!
    var index: Int = 0
    var dataSource: [YHResignCertificateModel]? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(8)
            make.bottom.equalTo(-8)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.text = "新增受养人"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.right.equalTo(-20)
        }
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.top.equalTo(52)
        }
        
    }
    
    func updateAllViews() {
        mainItemView.removeSubviews()
        guard let dataSource = dataSource else {
            return
        }
        var total = 0
        for i in 0 ..< dataSource.count {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            mainItemView.addSubview(line)
            line.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(total)
                make.height.equalTo(0.5)
                make.right.equalTo(-18)
            }
            total += 1
            let itemView = YHResignCertificateView()
            itemView.index = index
            itemView.clickBlock = {[weak self] model in
                guard let self = self else { return }
                if let block = self.clickBlock {
                    block(model)
                }
            }
            let model = dataSource[i]
            itemView.tag = 4000 + i
            itemView.dataSource = dataSource[i]
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(total)
                make.height.equalTo(51)
                make.right.equalTo(-18)
            }
            total += 51
        }
    }
}

class YHResignCertificateView: UIView {
    typealias ItemBlock = (_ model: YHResignCertificateModel) -> Void
    var clickBlock: ItemBlock?
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var explainLabel: UILabel!
    var nextStepImageView: UIImageView!
    var centerButton: UIButton!
    var index: Int = 0

    var dataSource: YHResignCertificateModel? {
        didSet {
            updateAllViews()
        }
    }
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_B(ofSize: 14)
            label.textAlignment = .left
            label.numberOfLines = 2
            label.textColor = UIColor.mainTextColor
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.top.bottom.equalToSuperview()
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textAlignment = .left
            label.numberOfLines = 2
            label.textColor = UIColor.mainTextColor50
            return label
        }()
        addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(titleLabel.snp.right)
        }
        
        explainLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textAlignment = .right
            label.textColor = UIColor.labelTextColor2
            return label
        }()
        addSubview(explainLabel)
        explainLabel.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.left.equalToSuperview()
            make.height.equalTo(20)
            make.centerY.equalToSuperview()
        }
        
        nextStepImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "form_right_arrow")
            return imageView
        }()
        addSubview(nextStepImageView)
        nextStepImageView.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalTo(explainLabel.snp.centerY)
            make.height.width.equalTo(20)
        }
        
        centerButton = {
            let button = UIButton(type: .custom)
            button.addTarget(self, action: #selector(centerClick), for: .touchUpInside)
            return button
        }()
        addSubview(centerButton)
        centerButton.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview()
            make.left.equalTo(112)
        }
        
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        titleLabel.text = dataSource.name
        if dataSource.status == 1 {
            explainLabel.text = "待上传"
            explainLabel.textColor = UIColor.brandMainColor
            nextStepImageView.image = UIImage(named: "service_adopter_income_start")
        }
        if dataSource.status == 2 {
            explainLabel.text = "已完成"
            explainLabel.textColor = UIColor(hex: 0x3cc694)
            nextStepImageView.image = UIImage(named: "service_adopter_income_success")
        }
        
        if dataSource.cert_type == "PASS_PORT" {
            subTitleLabel.text = " (护照入境)"
        } else if dataSource.cert_type == "HK_PASS_PORT" {
            subTitleLabel.text = " (港澳通行证入境)"
        } else {
            subTitleLabel.text = ""
        }
        
        if dataSource.age < 11, index == 2 {
            explainLabel.text = "无需提供"
            subTitleLabel.text = " (未满11岁)"
            explainLabel.textColor = UIColor.mainTextColor18
            nextStepImageView.isHidden = true
            explainLabel.snp.remakeConstraints { make in
                make.right.left.equalToSuperview()
                make.height.equalTo(20)
                make.centerY.equalToSuperview()
            }
        } else {
            nextStepImageView.isHidden = false
            explainLabel.snp.remakeConstraints { make in
                make.right.equalTo(-20)
                make.left.equalToSuperview()
                make.height.equalTo(20)
                make.centerY.equalToSuperview()
            }
        }
        
    }
    
    @objc func centerClick() {
        if let block = clickBlock {
            block(self.dataSource ?? YHResignCertificateModel())
        }
    }
    
    func isShowDelete(_ index: Int, isShow: Bool) {
        if isShow {
            explainLabel.isHidden = true
            nextStepImageView.isHidden = true
        } else {
            explainLabel.isHidden = false
            nextStepImageView.isHidden = false
        }
    }
}
