//
//  YHResignDocumentUploadStatus.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

enum YHResignDocumentUploadStatus: Int, CaseIterable {
    case pendingUpload = 0
    case notSent = 1
    case sending = 2
    case sent = 3
    case received = 4
    case approved = 5
    case rejected = 6
    
    var description: String {
        switch self {
        case .pendingUpload:
            return "待上传"
        case .notSent:
            return "未发送"
        case .sending:
            return "发送中"
        case .sent:
            return "已发送"
        case .received:
            return "已签收"
        case .approved:
            return "审核通过"
        case .rejected:
            return "驳回"
        }
    }
}
