//
//  YHResignDocumentContentCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignDocumentContentCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHResignDocumentContentCell"
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 14)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor50
        label.font = .PFSC_R(ofSize: 14)
        return label
    }()
    
    private lazy var rightIconView: UIImageView = {
        let view = UIImageView()
        return view
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        view.isHidden = true
        return view
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String?, cellType: YHResignRoundCellType = .top, status: YHResignDocumentStatus = .awaitingSignature) {
        infoTitleLabel.text = title
        infoDetailLabel.text = status.title()
        infoDetailLabel.textColor = status.textColor()
        rightIconView.image = UIImage(named: status.iconName())
        bottomLineView.isHidden = (cellType == .bottom)
        updateCellCorner(cellType)
    }
}

extension YHResignDocumentContentCell {
    
    private func setupUI() {
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(rightIconView)
        subContainerView.addSubview(bottomLineView)
        infoTitleLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        rightIconView.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        bottomLineView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.bottom.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.centerY.equalToSuperview()
        }
        
        rightIconView.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-18)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(20)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(16)
            make.centerY.equalToSuperview()
            make.right.equalTo(rightIconView.snp.left)
        }
    }
}
