//
//  YHResignGuidelinesExampleViewController.swift
//  galaxy
//
//  Created by EDY on 2024/9/14.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Kingfisher

enum YHResignGuidelinesExampleType: Int {
    case house
    case work
    case taxation
    case noWork
}

class YHResignGuidelinesExampleViewController: YHBaseViewController {
    var tableView: UITableView!
    var nextButton: UIButton!
    var url: String = ""
    var imageName: String = ""
    var type: YHResignGuidelinesExampleType = .house
//    var viewModel = YHResignCertificateListViewModel()
    var viewModel = YHResignGuidelinesViewModel()
    var height: CGFloat = 0
    var id: Int = -1
    
    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navTitle = "银河续签案例分享"
        gk_navBackgroundColor = .white
        gk_navBarAlpha = 1.0
        setView()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        getData()
    }
    
    func getData() {
//        if type == .house {
//            imageName = "resign_guidelines_example_house"
//        } else if type == .work {
//            imageName = "resign_guidelines_example_work"
//        } else if type == .taxation {
//            imageName = "resign_guidelines_example_taxation"
//        } else {
//            imageName = "resign_guidelines_example_nowork"
//        }
        
        viewModel.getResignDetail(Id: id) {[weak self] _, _ in
            guard let self = self else { return }
            self.imageName = self.viewModel.mainModel.content_url
            self.getImageSizeFromURL(urlString: self.imageName)
        }
    }
    
    func setView() {
        tableView = {
            let tableView = UITableView(frame: .zero, style: .plain)
            tableView.contentInsetAdjustmentBehavior = .never
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.showsVerticalScrollIndicator = false
            tableView.showsHorizontalScrollIndicator = false
            tableView.register(cellWithClass: YHResignGuidelinesExampleTableViewCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.equalTo(view)
            make.bottom.equalTo(-98)
        }
        let bottonView = UIView()
        bottonView.backgroundColor = .white
        bottonView.isHidden = true
        view.addSubview(bottonView)
        bottonView.snp.makeConstraints { make in
            make.height.equalTo(98)
            make.bottom.left.right.equalTo(view)
        }
        
        nextButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("立即分享", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(nextStep), for: .touchUpInside)
            return button
        }()
        view.addSubview(nextButton)
        nextButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-8 - k_Height_safeAreaInsetsBottom())
            make.height.equalTo(48)
        }
        
    }
    
    @objc func nextStep() {
//        var imageName = ""
//        if type == .house {
//            imageName = "resign_guidelines_example_house_share"
//        } else if type == .work {
//            imageName = "resign_guidelines_example_work_share"
//        } else if type == .taxation {
//            imageName = "resign_guidelines_example_taxation_share"
//        } else {
//            imageName = "resign_guidelines_example_nowork_share"
//        }
        let vc = YHResignGuidelinesExampleShareViewController()
        vc.centerImageName = self.viewModel.mainModel.share_url
        self.navigationController?.pushViewController(vc)
    }
    
    func getImageSizeFromURL(urlString: String) {
        guard let imageURL = URL(string: urlString) else { return }
         
        // 使用Kingfisher的ImageDownloader下载图片数据
        ImageDownloader.default.downloadImage(with: imageURL, options: [], progressBlock: nil) { (result) in
            switch result {
            case .success(let response):
                // 使用UIImage初始化图片数据
                let image = response.image
                let size = image.size
                let scale = size.width > 0 ? Double(size.height / size.width) : 0.0
                // 获取图片的宽度和高度
                self.height = KScreenWidth * scale
                self.tableView.reloadData()
            case .failure(let error):
                print(error)
            }
        }
    }
}

extension YHResignGuidelinesExampleViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHResignGuidelinesExampleTableViewCell.self)
        cell.imageName = imageName
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
//        if type == .house {
//            return 986.fix
//        } else if type == .work {
//            return 925.fix
//        } else if type == .taxation {
//            return 946.fix
//        } else {
//            return 1069.fix
//        }
        
        return height
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
    }
    
}

class YHResignGuidelinesExampleTableViewCell: UITableViewCell {
    var bgImageView: UIImageView!
    var imageName: String? {
        didSet {
            bgImageView.kf.setImage(with: URL(string: imageName))
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear

        bgImageView = {
            let imageView = UIImageView()
            return imageView
        }()
        contentView.addSubview(bgImageView)
        bgImageView.snp.makeConstraints { make in
            make.top.left.right.bottom.equalToSuperview()
        }
        
    }
}
