//
//  YHResignAppointGroup.swift
//  galaxy
//
//  Created by edy on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHResignAppointTogetherSetting: SmartCodable {
    var is_together: Int = 0  // 0未选择  1是 2不是 一起赴港
    var isCanEdit: Bool = true // 是否可编辑
    required init() {
        
    }
}

class YHResignScheduleListModel: SmartCodable {
    
    var is_together: Int = 0 // 1 是2不是 一起赴港
    var result_open: Bool = false // 是否可以下一步，去查看递交凭证
    var renewal_List: [YHResignAppointGroup] = []
    
    required init() {
        
    }
}

class YHResignAppointGroup: SmartCodable {
    
    var id: Int = 0
    var user_list: [YHResignAppointUser] = []
    var ready_to_submit_at: String = ""
    var leave_hk_at: String = ""
    var determine_hk_at: String = ""
    var actually_submit_at: String = ""
    var result_file_at: String = ""
    var is_edit: Int = 0
    // 自定义 第几批
    var batchIndex: Int = 0
    var apply_payment: Int = 0  // 0不需要缴费，1需要缴费
    
    func isNeedPayment() -> Bool {
        return apply_payment == 1
    }
    
    func getSubmitHKTime() -> String {
        let format = "yyyy-MM-dd HH:mm"
        if ready_to_submit_at.count <= format.count {
            return ready_to_submit_at
        }
        return String(ready_to_submit_at.prefix(format.count))
    }
    
    func getConfirmHKTime() -> String {
        let format = "yyyy-MM-dd HH:mm"
        if determine_hk_at.count <= format.count {
            return determine_hk_at
        }
        return String(determine_hk_at.prefix(format.count))
    }
    
    func getConfirmInHKStatus() -> YHResignConfirmHKStatus {
        
//      test  return .haveConfirmHK
        
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd HH:mm"
        let nowDateString = dateFormatter.string(from: Date())
        
        var confirmStatus = YHResignConfirmHKStatus.waitConfirmHK
        
        if self.determine_hk_at.isEmpty {
            // 是否到了预约递交时间
            let isArriveSubmitTime = compareDates(self.ready_to_submit_at, nowDateString)
            if isArriveSubmitTime {
                confirmStatus = .waitConfirmHK
            } else {
                confirmStatus = .canConfirmHK
            }
            
        } else { // 有确认在港日期
            confirmStatus = .haveConfirmHK
        }
        return confirmStatus
    }
    
    // dateString1 是否不小于dateString2
    func compareDates(_ dateStr1: String, _ dateStr2: String) -> Bool {
        
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd HH:mm"
        let dateFormatCount = dateFormatter.dateFormat.count
        
        var dateString1 = dateStr1
        if dateString1.count > dateFormatCount {
            dateString1 = String(dateString1.prefix(dateFormatCount))
        }
        var dateString2 = dateStr2
        if dateString2.count > dateFormatCount {
            dateString2 = String(dateString2.prefix(dateFormatCount))
        }
        
        // 将字符串转换为 Date 对象
        guard let date1 = dateFormatter.date(from: dateString1),
              let date2 = dateFormatter.date(from: dateString2) else {
            print("日期格式错误")
            return true
        }
        
        // 比较日期
        if date1 < date2 {
            print("\(dateString1) 小于 \(dateString2)")
            return false
        }
        return true
    }
    
    required init() {
        
    }
}

class YHResignAppointUser: SmartCodable, NSCopying {
    
    var id: Int = 0
    var name: String = ""
    var memberId: Int = 0
    
    required init() {
        
    }
    
    init(id: Int, name: String, memberId: Int) {
        self.id = id
        self.name = name
        self.memberId = memberId
    }
    
    func copy(with zone: NSZone? = nil) -> Any {
        return YHResignAppointUser(id: self.id, name: self.name, memberId: self.memberId)
    }
    
    func transformToMember() -> YHResignAppointMember {
        let m = YHResignAppointMember()
        m.id = self.memberId
        m.apply_name = self.name
        return m
    }
}

// [YHResignAppointUser] 数组实现神拷贝
extension Array where Element == YHResignAppointUser {
    
    func deepCopy() -> [YHResignAppointUser] {
        var results: [YHResignAppointUser] = []
        for item in self {
            if let newItem = item.copy() as? YHResignAppointUser {
                results.append(newItem)
            }
        }
        return results
    }
}
