//
//  YHResignAppointTimeSettingModel.swift
//  galaxy
//
//  Created by edy on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHResignAppointTimeSettingModel: SmartCodable {

    var ready_to_submit_at: String = ""  // 预约在港递交时间
    var leave_hk_at: String = ""   // 预计离港时间
    var notleaveHK: Bool = false // 暂不离港
    var users: [YHResignAppointMember] = []
    var isShowUsers: Bool = false // 是否展示选择用户列表
    var itemIndex: Int = 0 // 第几批 从0开始
    var isClickSubmit: Bool = false
    var isHaveAppointed: Bool = false
    
    func getLeaveHKTime() -> String {
        let format = "yyyy-MM-dd HH:mm"
        if leave_hk_at.count <= format.count {
            return leave_hk_at
        }
        return String(leave_hk_at.prefix(format.count))
    }
    
    func getSubmitHKTime() -> String {
        let format = "yyyy-MM-dd HH:mm"
        if ready_to_submit_at.count <= format.count {
            return ready_to_submit_at
        }
        return String(ready_to_submit_at.prefix(format.count))
    }
    
    required init() {
        
    }
    
}
