//
//  YHResignAppointTipsView.swift
//  galaxy
//
//  Created by edy on 2024/10/9.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignAppointSubmitTipsView: UIView {

    var confirmBlock: (() -> Void)?
    
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.init(hex: 0x000000, alpha: 0.68)
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.textColor = UIColor.mainTextColor
        label.text = "递交提示"
        return label
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0x94A3B8, alpha: 0.14)
        return view
    }()
    
    lazy var textImgView: UIImageView = {
        let imgView = UIImageView(image: UIImage(named: "resign_appoint_tips"))
        return imgView
    }()
    
    lazy var confirmBtn: UIButton = {
        let button = UIButton()
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        button.setTitle("我知道了", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.backgroundColor = .brandMainColor
        button.addTarget(self, action: #selector(didConfirmBtnClicked), for: .touchUpInside)
        button.layer.cornerRadius = kCornerRadius3
        return button
    }()
    
    static func alertView() -> YHResignAppointSubmitTipsView {
        let view = YHResignAppointSubmitTipsView(frame: UIScreen.main.bounds)
        return view
    }
    
    @objc func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        self.removeFromSuperview()
    }
    
    @objc func didConfirmBtnClicked() {
        confirmBlock?()
        self.dismiss()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    func createUI() {
        
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(textImgView)
        whiteContentView.addSubview(confirmBtn)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.right.equalTo(-38)
            make.centerY.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.left.equalTo(21)
            make.right.equalTo(-21)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.right.equalTo(0)
            make.height.equalTo(0.5)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)

        }
        
        textImgView.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(textImgView.snp.width).multipliedBy(380.0/257.0)
            make.top.equalTo(lineView.snp.bottom).offset(18)
        }
        
        confirmBtn.snp.makeConstraints { make in
            make.top.equalTo(textImgView.snp.bottom).offset(32)
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.bottom.equalTo(-16)
            make.height.equalTo(45)
        }
        
    }

}
