//
//  YHResignAppointedScheduleLineView.swift
//  galaxy
//
//  Created by edy on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHScheduleLineStepModel {
    
    var index: Int = 0
    var title: String = ""
    var time: String = ""
    var isNeedUserAction: Bool = true // 该步骤是否需要用户操作
    
    init(title: String, time: String, isNeedUserAction: Bool = true) {
        self.title = title
        self.time = time
        self.isNeedUserAction = isNeedUserAction
    }
}

class YHResignAppointedScheduleLineView: UIView {

    var steps: [YHScheduleLineStepModel] = {
        let model1 = YHScheduleLineStepModel(title: "入境香港准备", time: "")
        let model2 = YHScheduleLineStepModel(title: "已确认在港", time: "")
        let model3 = YHScheduleLineStepModel(title: "银河递交续签资料", time: "", isNeedUserAction: false)
        let model4 = YHScheduleLineStepModel(title: "查看递交回执", time: "")
        let model5 = YHScheduleLineStepModel(title: "在港等待获批/离港", time: "")
        let model6 = YHScheduleLineStepModel(title: "在港等缴费领取新签证", time: "")
        let model7 = YHScheduleLineStepModel(title: "更新续签旅行证件", time: "")
        return [model1, model2, model3, model4, model5, model6, model7]
    }()
    
    lazy var collectView: UICollectionView = {
        // 设置布局方向
        let flowLayout = UICollectionViewFlowLayout()
        flowLayout.minimumInteritemSpacing = 0.0
        flowLayout.minimumLineSpacing = 0.0
        flowLayout.scrollDirection = .horizontal
        
        let collectionView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectionView.backgroundColor = .clear
        collectionView.register(YHResignScheduleLineCollectCell.self, forCellWithReuseIdentifier: YHResignScheduleLineCollectCell.cellReuseIdentifier)
        collectionView.delegate = self
        collectionView.dataSource = self
        collectionView.bounces = false
        collectionView.showsHorizontalScrollIndicator = false
        return collectionView
    }()
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    func getDateOfYYYYMMDD(_ dateString: String) -> String {
        // dateString格式为yyyy-MM-dd HH:mm:ss 返回yyyy-MM-dd
        let format = "yyyy-MM-dd"
        if dateString.count <= format.count {
            return dateString
        }
        return String(dateString.prefix(format.count))
    }
    
    // 已确认在港时间 银河递交续签资料时间 查看递交回执时间
    func updateDates(confirmDate: String, submitDate: String, watchDate: String) {
        
        let newConfirmDate = getDateOfYYYYMMDD(confirmDate)
        let newSubmitDate = getDateOfYYYYMMDD(submitDate)
        let newWatchDate = getDateOfYYYYMMDD(watchDate)

        if steps.count >= 2 { // 已确认在港节点
            let confirmModel = steps[1]
            confirmModel.time = newConfirmDate
        }
        
        if steps.count >= 3 { // 银河递交续签资料节点
            let submitModel = steps[2]
            submitModel.time = newSubmitDate
        }
        
        if steps.count >= 4 { // 查看递交回执节点
            let watchModel = steps[3]
            watchModel.time = newWatchDate
        }
        self.collectView.reloadData()
    }
    
    func createUI() {
        self.backgroundColor = .init(hex: 0xF8F9FB)
        self.layer.cornerRadius = 4.0
        self.clipsToBounds = true
        self.addSubview(collectView)
        collectView.reloadData()
        collectView.snp.makeConstraints { make in
            make.left.equalTo(9)
            make.right.equalTo(-9)
            make.top.bottom.equalToSuperview()
        }
    }
}

extension YHResignAppointedScheduleLineView: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout {
    
        // 返回单元格数量
        func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
            
            return steps.count
        }
        
        // 返回每个单元格的大小
        func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
            
            if 0 <= indexPath.item && indexPath.item < steps.count {
                let model = steps[indexPath.item]
                let size = self.getwith(font: UIFont.PFSC_R(ofSize: 11), height: 15, string: model.title)
                var width = ceil(Double(size.width))
                if width < 65.0 {
                    width = 65.0
                }
                width += 18.0
                return CGSize(width: width, height: 84.0)
            }
            return .zero
        }
        
        // 返回自定义单元格
        func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
            guard let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHResignScheduleLineCollectCell.cellReuseIdentifier, for: indexPath) as? YHResignScheduleLineCollectCell else {
                return UICollectionViewCell()
            }
            if 0 <= indexPath.item && indexPath.item < steps.count {
                let model = steps[indexPath.item]
                model.index = indexPath.item+1
                cell.updateModel(model)
                if indexPath.item == 0 {
                    cell.leftDotView.isHidden = true
                    cell.rightDotView.isHidden = false
                    
                } else if indexPath.item == steps.count-1 {
                    cell.leftDotView.isHidden = false
                    cell.rightDotView.isHidden = true
                    
                } else {
                    cell.leftDotView.isHidden = false
                    cell.rightDotView.isHidden = false
                }
            }
            return cell
        }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if 0 <= indexPath.item && indexPath.item < steps.count {
            let model = steps[indexPath.item]
        }
    }
    
    // 计算文字宽度大小
    func getwith(font: UIFont, height: CGFloat, string: String) -> CGSize {
        let size = CGSize.init(width: CGFloat(MAXFLOAT), height: height)
        let dic = [NSAttributedString.Key.font: font] // swift 4.2
        let strSize = string.boundingRect(with: size, options: [.usesLineFragmentOrigin], attributes: dic, context: nil).size
        return CGSize(width: ceil(strSize.width), height: strSize.height)
    }
}
