//
//  YHResignLeaveHKSwitchItemView.swift
//  galaxy
//
//  Created by edy on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignLeaveHKSwitchItemView: UIView {

    var selectBlock: ((Bool) -> Void)?
    
    var title: String = "" {
        didSet {
            titleLabel.text = title
        }
    }
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor
        return label
    }()
    
    lazy var switchBtn: UISwitch = {
        let switchBtn = UISwitch()
        switchBtn.onTintColor =  UIColor.brandMainColor
        switchBtn.addTarget(self, action: #selector(switchViewChange), for: .valueChanged)
        switchBtn.tintColor = .brandMainColor
        switchBtn.isOn = getVideoPlaySilentSettings()
        return switchBtn
    }()
    
    lazy var btnView: UIView = {
        let btnView = UIView()
        btnView.addSubview(switchBtn)
        return btnView
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        self.addSubview(titleLabel)
        self.addSubview(btnView)
        self.addSubview(lineView)
        
        lineView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.equalTo(0)
            make.height.equalTo(0.5)
        }

        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.top.equalTo(0)
            make.bottom.equalTo(0)
            make.width.equalTo(112)
            make.height.equalTo(52)
        }
        
        btnView.snp.makeConstraints { make in
            make.right.equalTo(0)
            make.centerY.equalToSuperview()
            make.height.equalTo(22)
            make.width.equalTo(40)
        }
    }
    
    @objc func switchViewChange() {
        selectBlock?(switchBtn.isOn)
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        switchBtn.transform = CGAffineTransform(scaleX: 0.70, y: 0.70)
        switchBtn.snp.updateConstraints { make in
            make.left.equalTo(-7)
            make.centerY.equalToSuperview()
        }
    }
}
