//
//  YHResignScheduleSingleInfoCell.swift
//  galaxy
//
//  Created by edy on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHResignConfirmHKStatus: Int {
    case waitConfirmHK = 0 // 待确认在港
    case canConfirmHK = 1 // 可点击确认在港
    case haveConfirmHK = 2 // 已确认在港
}

class YHResignScheduleSingleInfoCell: UITableViewCell {

    static let cellReuseIdentifier = "YHResignScheduleSingleInfoCell"
    
    var clickConfirmBtnBlock: ((YHResignConfirmHKStatus) -> Void)?
    var applyPaymentBlock: (() -> Void)?
    var modifyBtnBlock: (() -> Void)?

    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.textColor = .mainTextColor
        label.text = "赴港递交已预约"
        return label
    }()
    
    lazy var modifyBtn: UIButton = {
        let btn = UIButton()
        btn.setTitle("修改", for: .normal)
        btn.setTitleColor(.brandMainColor, for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 14)
        btn.addTarget(self, action: #selector(didModifyBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var batchView: YHResignAppointedScheduleSingleItemView = {
        let view = YHResignAppointedScheduleSingleItemView(frame: .zero)
        view.clickConfirmBtnBlock = {
            [weak self] status in
            guard let self = self else { return }
            self.clickConfirmBtnBlock?(status)
        }
        view.applyPaymentBlock = {
            [weak self]  in
            guard let self = self else { return }
            self.applyPaymentBlock?()
        }
        return view
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func updateModel(_ model: YHResignAppointGroup) {
        batchView.updateModel(model)
    }
    
    @objc func didModifyBtnClicked() {
        modifyBtnBlock?()
    }
    
    func setupUI() {
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(modifyBtn)
        whiteContentView.addSubview(batchView)
        
        whiteContentView.snp.makeConstraints { make in
            make.top.equalTo(0)
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.bottom.equalTo(-16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(24)
        }
        
        modifyBtn.snp.makeConstraints { make in
            make.width.equalTo(28)
            make.height.equalTo(24)
            make.right.equalTo(-18)
            make.centerY.equalTo(titleLabel)
        }
        
        batchView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.bottom.equalTo(0)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
        }
    }

}
