//
//  YHResignAppointViewModel.swift
//  galaxy
//
//  Created by edy on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignAppointViewModel: NSObject {

    // 赴港人员列表
    var appointUsers: [YHResignAppointMember] = []
    // 预约列表预约
    var scheduleInfoList: YHResignScheduleListModel = YHResignScheduleListModel()
    
    // 赴港人员列表
    func getResignAppointUserlist(renewalId: Int, callBack: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params = ["renewal_id": renewalId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignAppoint.appointUserList
        _ = YHNetRequest.getRequest(url: strUrl, params: params) {
            [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [Any], let resultModel = [YHResignAppointMember].deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    self.appointUsers = []
                    callBack(false, err)
                    return
                }
                self.appointUsers = resultModel
                callBack(true, nil)
                
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                self.appointUsers = []
                callBack(false, error)
            }
            
        } failBlock: { err in
            self.appointUsers = []
            callBack(false, err)
        }
    }
    
    func getUsers() -> [YHResignAppointMember] {
        
        let m1 = YHResignAppointMember()
        m1.apply_name = "刘德华"
        m1.id = 123
        
        let m2 = YHResignAppointMember()
        m2.apply_name = "黎明"
        m2.id = 124
        
        let m3 = YHResignAppointMember()
        m3.apply_name = "郭富城"
        m3.id = 125
        
        let m4 = YHResignAppointMember()
        m4.apply_name = "张学友"
        m4.id = 126
        
        return [m1, m2, m3, m4]
    }
    
    // 预约列表预约
    func getScheduleInfoList(renewalId: Int, callBack: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params = ["renewal_id": renewalId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignAppoint.appointInfoList
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignScheduleListModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBack(false, err)
                    return
                }
                self.scheduleInfoList = resultModel
                callBack(true, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                self.scheduleInfoList = YHResignScheduleListModel()
                callBack(false, err)
            }
        } failBlock: { err in
            self.scheduleInfoList = YHResignScheduleListModel()
            callBack(false, err)
        }
    }
    
    // 提交预约
    func submitAppointInfo(params: [String: Any], callBack: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignAppoint.submitAppoint
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBack(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBack(false, error)
            }
        } failBlock: { err in
            callBack(false, err)
        }
    }
    
    // 点击确认在港
    func submitConfirmInHK(id: Int, is_edit: Int, callBack: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id,
                                     "is_edit": is_edit]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignAppoint.confirmInHK
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let _ = self else { return }
            if json.code == 200 {
                callBack(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBack(false, error)
            }
        } failBlock: { err in
            callBack(false, err)
        }
    }
}
