//
//  YHResignUploadDocListCell.swift
//  galaxy
//
//  Created by EDY on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignUploadDocListCell: UITableViewCell {
    static let cellReuseIdentifier = "YHResignUploadDocListCell"

    typealias ExperienceListBlock = (_ model: YHResignUploadDocModel, _ section: Int) -> Void
    var clickBlock: ExperienceListBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var mainItemView: UIView!
    var lineView: UIView!
    var title: String = "" {
        didSet {
            titleLabel.text = title
        }
    }
    var section: Int = 0
    var dataSource: [YHResignUploadDocModel]? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.bottom.equalToSuperview()
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.text = "新增受养人"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.right.equalTo(-20)
        }
    
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(51.5)
            make.height.equalTo(0.5)
        }
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.top.equalTo(52)
        }
    }
    
    func getHeight(_ value: String) -> CGFloat {
        let text = value // 要显示的文本内容
        let font = UIFont.PFSC_B(ofSize: 14) // 字体大小
        let maxWidth = KScreenWidth - 146 // 最大宽度限制
        
        // 创建NSAttributedString对象并设置属性
        let attributes = [NSAttributedString.Key.font: font] as [NSAttributedString.Key: Any]
        _ = NSMutableAttributedString(string: text, attributes: attributes)
         
        // 根据指定的最大宽度和字体大小计算文本的高度
        let size = (text as NSString).boundingRect(with: CGSize(width: maxWidth, height: .greatestFiniteMagnitude), options: .usesLineFragmentOrigin, attributes: attributes, context: nil).size
        return size.height
    }
    
    func updateAllViews() {
        mainItemView.removeSubviews()
        guard let dataSource = dataSource else {
            return
        }
        var total = 0
        for i in 0 ..< dataSource.count {
            if i != 0 {
                let line = UIView()
                line.backgroundColor = UIColor.separatorColor
                mainItemView.addSubview(line)
                line.snp.makeConstraints { make in
                    make.left.equalTo(18)
                    make.top.equalTo(total)
                    make.height.equalTo(0.5)
                    make.right.equalTo(-18)
                }
            }
            total += 1
            let itemView = YHResignUploadDocItemView()
            itemView.clickBlock = {[weak self] model in
                guard let self = self else { return }
                if let block = self.clickBlock {
                    block(model, self.section)
                }
            }
            itemView.tag = 4000 + i
            if section == 0 {
                itemView.dataSource = dataSource[i]
            } else {
                itemView.docDataSource = dataSource[i]
            }
            let height = getHeight(dataSource[i].name)
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.equalTo(18)
                make.top.equalTo(total)
                make.height.equalTo(height + 31)
                make.right.equalTo(-18)
            }
            total += Int(height + 31)
        }
    }

}

class YHResignUploadDocItemView: UIView {
    typealias ItemBlock = (_ model: YHResignUploadDocModel) -> Void
    var clickBlock: ItemBlock?
    var deleteBlock: ItemBlock?
    var titleLabel: UILabel!
    var explainLabel: UILabel!
    var nextStepImageView: UIImageView!
    var centerButton: UIButton!

    var dataSource: YHResignUploadDocModel? {
        didSet {
            updateAllViews()
        }
    }
    var docDataSource: YHResignUploadDocModel? {
        didSet {
            updateDocAllViews()
        }
    }
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_B(ofSize: 14)
            label.textAlignment = .left
            label.numberOfLines = 2
            label.textColor = UIColor.mainTextColor
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.top.bottom.equalToSuperview()
            make.right.equalTo(-70)
        }
        
        explainLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textAlignment = .right
            label.textColor = UIColor.labelTextColor2
            return label
        }()
        addSubview(explainLabel)
        explainLabel.snp.makeConstraints { make in
            make.right.equalTo(-24)
            make.left.equalToSuperview()
            make.height.equalTo(20)
            make.centerY.equalToSuperview()
        }
        
        nextStepImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "form_right_arrow")
            return imageView
        }()
        addSubview(nextStepImageView)
        nextStepImageView.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalTo(explainLabel.snp.centerY)
            make.height.width.equalTo(20)
        }
        
        centerButton = {
            let button = UIButton(type: .custom)
            button.addTarget(self, action: #selector(centerClick), for: .touchUpInside)
            return button
        }()
        addSubview(centerButton)
        centerButton.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview()
            make.left.equalTo(112)
        }
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        titleLabel.text = dataSource.name
        if dataSource.status == 3 {
            explainLabel.text = "待上传"
            explainLabel.textColor = UIColor.brandMainColor
            nextStepImageView.image = UIImage(named: "service_adopter_income_start")
        }
        if dataSource.status == 0 {
            explainLabel.text = "审核中"
            explainLabel.textColor = UIColor(hex: 0xff8000)
            nextStepImageView.image = UIImage(named: "service_adopter_income_wait")
        }
        if dataSource.status == 2 {
            explainLabel.text = "已驳回"
            explainLabel.textColor = UIColor.failColor
            nextStepImageView.image = UIImage(named: "service_adopter_income_fail")
        }
        if dataSource.status == 1 {
            explainLabel.text = "已完成"
            explainLabel.textColor = UIColor(hex: 0x3cc694)
            nextStepImageView.image = UIImage(named: "service_adopter_income_success")
        }
    }
    
    func updateDocAllViews() {
        guard let dataSource = docDataSource else { return }
        titleLabel.text = dataSource.name
        if dataSource.status == 1 {
            explainLabel.text = "待确认"
            explainLabel.textColor = UIColor.brandMainColor
            nextStepImageView.image = UIImage(named: "service_adopter_income_start")
        }
        if dataSource.status == 4 {
            explainLabel.text = "待签字"
            explainLabel.textColor = UIColor.brandMainColor
            nextStepImageView.image = UIImage(named: "service_adopter_income_start")
        }
        if dataSource.status == 0 {
            explainLabel.text = "写作中"//
            explainLabel.textColor = UIColor(hex: 0xff8000)
            nextStepImageView.image = UIImage(named: "service_adopter_income_wait")
        }
        if dataSource.status == 2 {
            explainLabel.text = "定稿中"// 定稿中 审核中
            explainLabel.textColor = UIColor(hex: 0xff8000)
            nextStepImageView.image = UIImage(named: "service_adopter_income_wait")
        }
        if dataSource.status == 3 {
            explainLabel.text = "审核中"// 定稿中 审核中
            explainLabel.textColor = UIColor(hex: 0xff8000)
            nextStepImageView.image = UIImage(named: "service_adopter_income_wait")
        }
        if dataSource.status == 6 {
            explainLabel.text = "已驳回"
            explainLabel.textColor = UIColor.failColor
            nextStepImageView.image = UIImage(named: "service_adopter_income_fail")
        }
        if dataSource.status == 5 {
            explainLabel.text = "已完成"
            explainLabel.textColor = UIColor(hex: 0x3cc694)
            nextStepImageView.image = UIImage(named: "service_adopter_income_success")

        }
    }
    
    @objc func centerClick() {
        if let block = clickBlock {
            if let model = self.dataSource {
                block(model)
            }
            if let model = self.docDataSource {
                block(model)
            }
        }
    }
    
}
