//
//  YHResignUploadSuccessDocListCell.swift
//  galaxy
//
//  Created by EDY on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignUploadSuccessDocListCell: UITableViewCell {
    static let cellReuseIdentifier = "YHResignUploadSuccessDocListCell"
    
    lazy var previewFileTool: YHFilePreviewTool = {
        let tool = YHFilePreviewTool(targetVC: UIViewController.current)
       return tool
    }()
    var mainItemView: UIView!
    var dataSource: [String]? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            view.layer.masksToBounds = true
            return view
        }()
        contentView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.bottom.equalToSuperview()
            make.left.equalTo(16)
            make.right.equalTo(-16)
        }
    }
    
    func updateAllViews() {
        mainItemView.removeSubviews()
        for i in 0 ..< (dataSource?.count ?? 0) {
            let itemView = YHResignUploadFileItemView()
            itemView.dataSource = dataSource?[i]
            itemView.block = {[weak self] model in
                guard let self = self else { return }
                let viewModel = YHBaseViewModel()
                viewModel.getPublicImageUrl(model) { success, _ in
                    if let success = success {
                        self.previewFileTool.openXLSXRemoteFile(urlString: success, fileName: "")
                    } else {
                        YHHUD.flash(message: "链接不可用")
                    }
                }
            }
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.right.equalToSuperview()
                make.top.equalTo(67 * i)
                make.height.equalTo(67)
            }
        }
    }
}

class YHResignUploadFileItemView: UIView {
    typealias ItemBlock = (_ model: String) -> Void
    var block: ItemBlock?
    var whiteView: UIButton!
    var iconImgV: UIImageView!
    var nameLabel: UILabel!
    var timeLabel: UILabel!
    var editBtn: UIButton!
    var dataSource: String? {
        didSet {
            updateAllViews()
        }
    }
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        whiteView = UIButton()
        whiteView.addTarget(self, action: #selector(itemClick), for: .touchUpInside)
        addSubview(whiteView)
        
        iconImgV = UIImageView(image: UIImage(named: "my_cer_type_jpg"))
        whiteView.addSubview(iconImgV)
        
        nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor
        nameLabel.textAlignment = .left
        nameLabel.numberOfLines = 0
        nameLabel.font = UIFont.PFSC_M(ofSize: 14)
        whiteView.addSubview(nameLabel)
        
        editBtn = UIButton()
        editBtn.setTitle("查看", for: .normal)
        editBtn.setTitleColor(UIColor.mainTextColor, for: .normal)
        editBtn.titleLabel?.font = UIFont.PFSC_M(ofSize: 11)
        editBtn.setBackgroundColor(color: UIColor(hex: 0xf4f6fa), forState: .normal)
        editBtn.YH_clickEdgeInsets = UIEdgeInsets(top: 30, left: 30, bottom: 30, right: 30)
        editBtn.addTarget(self, action: #selector(click), for: .touchUpInside)
        editBtn.layer.cornerRadius = 10
        whiteView.addSubview(editBtn)
        
        whiteView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.centerY.equalToSuperview()
            make.height.equalTo(67)
        }

        iconImgV.snp.makeConstraints { make in
            make.width.height.equalTo(31)
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(6)
        }
        
        nameLabel.snp.makeConstraints { make in
            make.left.equalTo(iconImgV.snp.right).offset(18)
            make.centerY.equalToSuperview()
            make.right.equalTo(editBtn.snp.left)
        }
        
        editBtn.snp.makeConstraints { make in
            make.width.equalTo(38)
            make.height.equalTo(20)
            make.centerY.equalToSuperview()
            make.right.equalToSuperview()
        }
        
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        let suffix = dataSource.pathExtension.lowercased()
        var iconImgName = ""
        
        if suffix == "jpeg" {
            iconImgName = "my_cer_type_jpg"
            
        } else if suffix == "jpg" {
            iconImgName = "my_cer_type_jpg"
            
        } else if suffix == "png" {
            iconImgName = "my_cer_type_png"
            
        } else if suffix == "pdf" {
            iconImgName = "my_cer_type_pdf"
            
        } else if suffix == "doc" || suffix == "docx" {
            iconImgName = "my_cer_type_word"
        
        } else if suffix == "ppt" || suffix == "pptx" {
            iconImgName = "my_cer_type_ppt"
        } else if suffix == "bmp" {
            iconImgName = "my_cer_type_bmp"
        } else if suffix == "tiff" {
            iconImgName = "my_cer_type_tiff"
        } else if suffix == "xls" || suffix == "xlsx" {
            iconImgName = "my_cer_type_excel"
        }
        nameLabel.text = "补件递交凭证." + suffix
        iconImgV.image = UIImage(named: iconImgName)
    }
    
    @objc func itemClick() {
        if let block = block, let dataSource = dataSource {
            block(dataSource)
        }
    }
    
    @objc func click() {
        itemClick()
    }
}
