//
//  YHResignUploadTravelCardListViewController.swift
//  galaxy
//
//  Created by EDY on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignUploadTravelCardListViewController: YHBaseViewController {
    var orderId: Int = 0
    var batchId: Int = 0

    lazy var viewModel: YHResignUploadTravelCardViewModel = {
        let vm = YHResignUploadTravelCardViewModel()
        return vm
    }()

    lazy var tableView: UITableView = {
        let tableView = UITableView(frame: .zero, style: .grouped)
        tableView.estimatedSectionHeaderHeight = 16.0
        tableView.estimatedSectionFooterHeight = 0.01
        tableView.contentInsetAdjustmentBehavior = .never
        tableView.showsVerticalScrollIndicator = false
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.tableHeaderView = YHResignUploadTravelCardListheadView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 16 + 90.fix))
        tableView.tableFooterView = YHResignUploadTravelCardListfootView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 837.fix))
        tableView.backgroundColor = .clear
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHResignUploadTravelCardListTableViewCell.self, forCellReuseIdentifier: YHResignUploadTravelCardListTableViewCell.cellReuseIdentifier)
        
        return tableView
    }()

    // 我已知悉，确认
    lazy var rewardBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitle("下一步，去查看续签总结", for: .normal)
        button.setTitle("下一步，去查看续签总结", for: .disabled)
        button.setTitleColor(UIColor.white, for: .normal)
        button.setTitleColor(UIColor.white, for: .disabled)
        button.setBackgroundColor(color: UIColor.brandMainColor, forState: .normal)
        button.setBackgroundColor(color: UIColor.brandMainColor.withAlphaComponent(0.3), forState: .disabled)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.addTarget(self, action: #selector(clickNextBtn), for: .touchUpInside)
        return button
    }()
    
    lazy var bottomView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.addSubview(self.rewardBtn)
        self.rewardBtn.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(10)
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.height.equalTo(44)
        }
        view.layer.zPosition = 10
        return view
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        loadData()
    }
    
    @objc func clickNextBtn() {
        if let param = YHLoginManager.shared.userModel?.token, param.count>5 {
            var url = YHBaseUrlManager.shared.curH5URL() + "superAppBridge.html#/report/program"
            url = url + "?param=" + YHLoginManager.shared.h5Token + "&batchID=\(batchId)" + "&order_id=\(orderId)"
            let vc = YHH5WebViewVC()
            vc.navTitle = "我的续签方案"
            vc.url = url
            vc.isSupportWebviewInterBackFlag = true
            self.navigationController?.pushViewController(vc)
        }
    }
}

private extension YHResignUploadTravelCardListViewController {
    func loadData() {
        let params: [String: Any] = ["order_id": orderId]
        YHHUD.show(.progress(message: "加载中..."))
        viewModel.getTravelDocsList(orderID: orderId, renewalId: batchId, callBackBlock: {[weak self] _, _ in
            YHHUD.hide()
            guard let self = self else { return }
            if self.viewModel.arrTravelDocs.is_report_redirect {
                rewardBtn.isEnabled = true
            } else {
                rewardBtn.isEnabled = false
            }
            self.tableView.reloadData()
        })
            
    }
    
    func setupUI() {
        gk_navTitle = "上传旅行证件"
        gk_navBarAlpha = 1.0
        gk_navBackgroundColor = .white
        view.backgroundColor = UIColor.contentBkgColor
        
        if orderId == 0 {
            if let id = UserDefaults.standard.value(forKey: "orderIdForPreview") {
                self.orderId = (id as? Int) ?? 0
            }
        }
        view.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.right.equalToSuperview()
            make.height.equalTo(98)
            make.bottom.equalToSuperview()
        }
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.right.equalToSuperview()
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalTo(-98)
        }
        
        let sublineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        view.addSubview(sublineView)
        sublineView.snp.remakeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(bottomView.snp.top)
            make.height.equalTo(1)
        }
    }
}

extension YHResignUploadTravelCardListViewController: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return viewModel.arrTravelDocs.list.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        guard let approveCell = tableView.dequeueReusableCell(withIdentifier: YHResignUploadTravelCardListTableViewCell.cellReuseIdentifier, for: indexPath) as? YHResignUploadTravelCardListTableViewCell else {
            return UITableViewCell()
        }
        approveCell.dataModel = viewModel.arrTravelDocs.list[indexPath.section]
        return approveCell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return YHTravelDocsPreparationListCell.cellH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let model = viewModel.arrTravelDocs.list[indexPath.section]
        if model.status == 2 {
            return
        } else {
            if model.travel_cert_type == 1 {
                // 跳转护照
                let vc = YHResignUploadTravelPassportViewController()
                vc.fatherData = model
                vc.batchId = batchId
                vc.orderId = orderId
                self.navigationController?.pushViewController(vc)
            } else {
                // 跳转港澳通行证
                let vc = YHResignUploadTravelHKViewController()
                vc.fatherData = model
                vc.batchId = batchId
                vc.orderId = orderId
                self.navigationController?.pushViewController(vc)
            }
        }
    }
    
    private func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> CGFloat {
        return 16.0
    }
    
    private func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        
        let view = UIView()
        return view
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        
        let view = UIView()
        return view
    }
}
