//
//  YHResignUploadTravelCardListfootView.swift
//  galaxy
//
//  Created by EDY on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHResignUploadTravelCardListfootView: UIView {
    var lineView: UIView!
    var titleLabel: UILabel!
    var controllerOne: YHResignUploadTravelCardFootViewController = YHResignUploadTravelCardFootViewController()
    var controllerTwo: YHResignUploadTravelCardFootViewController = YHResignUploadTravelCardFootViewController()
    var arrItemTitles = ["大陆办理", "香港办理"]
    var arrItemVCs: [YHResignUploadTravelCardFootViewController] = []
    var segmentedView: JXSegmentedView = JXSegmentedView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 48))
    lazy var segmentedDataSource: JXSegmentedDotDataSource = {
        let dataSource = JXSegmentedDotDataSource()
        dataSource.isTitleColorGradientEnabled = true
        dataSource.titles = arrItemTitles
        
        dataSource.titleNormalFont = UIFont.PFSC_M(ofSize: 14)
        dataSource.titleNormalColor = .labelTextColor2
        
        dataSource.titleSelectedFont = UIFont.PFSC_M(ofSize: 14)
        dataSource.titleSelectedColor = .mainTextColor
        
        dataSource.isItemSpacingAverageEnabled = false
        dataSource.itemWidth = JXSegmentedViewAutomaticDimension
        dataSource.itemSpacing = 16
        dataSource.dotStates = [false, false, false, false]
        dataSource.dotSize = CGSize(width: 6, height: 6)
        return dataSource
    }()
    
    // 分类title 所对应的VC
    lazy var listContainerView: JXSegmentedListContainerView! = {
        return JXSegmentedListContainerView(dataSource: self, type: .scrollView)
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        backgroundColor = .clear
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.brandMainColor
            return view
        }()
        addSubview(lineView)
        lineView.snp.remakeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(38)
            make.height.equalTo(12)
            make.width.equalTo(3)
        }
        
        titleLabel = {
            let view = UILabel()
            view.text = "港澳通行证逗留（D）签注延期-办理指引"
            view.font = UIFont.PFSC_M(ofSize: 17)
            view.textColor = UIColor.mainTextColor
            return view
        }()
        addSubview(titleLabel)
        titleLabel.snp.remakeConstraints { make in
            make.left.equalTo(27)
            make.centerY.equalTo(lineView.snp.centerY)
            make.height.equalTo(24)
            make.right.equalToSuperview()
        }
        
        controllerOne.type = 0
        controllerTwo.type = 1
        arrItemVCs.append(controllerOne)
        arrItemVCs.append(controllerTwo)
        
        // segmentedViewDataSource一定要通过属性强持有！！！！！！！！！
//        segmentedView.backgroundColor = .clear
        segmentedView.collectionView.backgroundColor = .white
//        segmentedView.contentScrollView?.backgroundColor = .clear
        addSubview(segmentedView)

        segmentedView.listContainer = listContainerView
        addSubview(listContainerView)
        
        // 分类Title
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        
        // 配置指示器
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorWidth = 16
        indicator.indicatorColor = UIColor.brandMainColor
        indicator.indicatorHeight = 2
        indicator.indicatorCornerRadius = 0
        indicator.verticalOffset = 1
        segmentedView.indicators = [indicator]
        segmentedView.backgroundColor = UIColor(red: 0.95, green: 0.95, blue: 0.95, alpha: 1)
        
        segmentedView.snp.remakeConstraints { make in
            make.right.equalTo(-16)
            make.left.equalTo(16)
            make.top.equalTo(82)
            make.height.equalTo(44)
        }
        listContainerView.snp.remakeConstraints { make in
            make.right.equalTo(-16)
            make.left.equalTo(16)
            make.top.equalTo(segmentedView.snp.bottom)
            make.height.equalTo(528.fix)
        }
        
        let whiteView = UIView()
        whiteView.backgroundColor = .white
        whiteView.layer.cornerRadius = kCornerRadius6
        whiteView.layer.maskedCorners = [.layerMinXMinYCorner, .layerMaxXMinYCorner]
        addSubview(whiteView)
        whiteView.snp.remakeConstraints { make in
            make.bottom.equalTo(segmentedView.snp.top)
            make.right.equalTo(-16)
            make.left.equalTo(16)
            make.height.equalTo(6)
        }
        
        let sublineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        segmentedView.addSubview(sublineView)
        sublineView.snp.remakeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(1)
        }
    }
}

extension YHResignUploadTravelCardListfootView: JXSegmentedViewDelegate {
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        if index == 0 {
            listContainerView.snp.remakeConstraints { make in
                make.right.equalTo(-16)
                make.left.equalTo(16)
                make.top.equalTo(segmentedView.snp.bottom)
                make.height.equalTo(528.fix)
            }
        } else {
            listContainerView.snp.remakeConstraints { make in
                make.right.equalTo(-16)
                make.left.equalTo(16)
                make.top.equalTo(segmentedView.snp.bottom)
                make.bottom.equalTo(-16)
            }
            
        }
//        NotificationCenter.default.post(name:  Notification.Name(rawValue: "scrollViewDidEndDragging"), object: nil)
    }

    /// 正在滚动中的回调
    ///
    /// - Parameters:
    ///   - segmentedView: JXSegmentedView
    ///   - leftIndex: 正在滚动中，相对位置处于左边的index
    ///   - rightIndex: 正在滚动中，相对位置处于右边的index
    ///   - percent: 从左往右计算的百分比
    func segmentedView(_ segmentedView: JXSegmentedView, scrollingFrom leftIndex: Int, to rightIndex: Int, percent: CGFloat) {
//        NotificationCenter.default.post(name:  Notification.Name(rawValue: "scrollViewWillBeginDragging"), object: nil)
    }
}

extension YHResignUploadTravelCardListfootView: JXSegmentedListContainerViewDataSource {
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        if let titleDataSource = segmentedView.dataSource as? JXSegmentedBaseDataSource {
            return titleDataSource.dataSource.count
        }
        return 0
    }

    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return arrItemVCs[index] as? JXSegmentedListContainerViewListDelegate ?? YHResignUploadTravelCardFootViewController()
    }
}
