//
//  YHResignUploadTravelCardDetailViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/10/14.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignUploadTravelCardDetailViewModel: YHBaseViewModel {
    var dataModel: YHResignUploadTravelCardDetailModel = YHResignUploadTravelCardDetailModel()

    func submitResignCertificateUpdate(_ params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.TravelCard.save
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func getBaseDataSource(_ isShowPrompt: Bool) -> [YHItemModel] {
        let item1 = YHItemModel(id: .id1, isNeed: true, title: "开始时间", isUserKeyBoard: false, prompts: "请选择", message: getResultString(dataModel.issue_start), type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择开始时间")
        let item2 = YHItemModel(id: .id2, isNeed: true, title: "到期时间", isUserKeyBoard: false, prompts: "请选择", message: getResultString(dataModel.issue_end), type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择到期时间")
        let item3 = YHItemModel(id: .id3, isNeed: true, title: "开始时间", isUserKeyBoard: false, prompts: "请选择", message: getResultString(dataModel.visa_start), type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择开始时间")
        let item4 = YHItemModel(id: .id4, isNeed: true, title: "到期时间", isUserKeyBoard: false, prompts: "请选择", message: getResultString(dataModel.visa_end), type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择到期时间")
        return [item1, item2, item3, item4]
    }
    
    func getPassPortDataSource(_ isShowPrompt: Bool) -> [YHItemModel] {
        let item1 = YHItemModel(id: .id5, isNeed: true, title: "签发日期", isUserKeyBoard: false, prompts: "请选择", message: getResultString(dataModel.issue_start), type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择开始时间")
        let item2 = YHItemModel(id: .id6, isNeed: true, title: "届满日期", isUserKeyBoard: false, prompts: "请选择", message: getResultString(dataModel.issue_end), type: .time, isShowPrompts: isShowPrompt, alertMessage: "请选择到期时间")
        return [item1, item2]
    }
    
    func updateModel(_ item: YHItemModel) {
        guard let type = item.id else { return }
        switch type {
        case .id1:
            dataModel.issue_start = item.message ?? ""
        case .id2:
            dataModel.issue_end = item.message ?? ""
        case .id3:
            dataModel.visa_start = item.message ?? ""
        case .id4:
            dataModel.visa_end = item.message ?? ""
        case .id5:
            dataModel.issue_start = item.message ?? ""
        case .id6:
            dataModel.issue_end = item.message ?? ""
        default:
            break
        }
    }
    
    func getResultString(_ data: String) -> String {
        let dateString = data // 原始日期时间字符串
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd HH:mm:ss" // 设置原始日期时间格式
        if let date = dateFormatter.date(from: dateString) {
            dateFormatter.dateFormat = "yyyy-MM-dd" // 设置目标日期格式
            let convertedDateString = dateFormatter.string(from: date) // 转换日期到目标格式
            return convertedDateString
        }
        return data
    }
    
    func getResignCertificateDetail(_ params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.TravelCard.detail
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignUploadTravelCardDetailModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                
                self.dataModel = resultModel
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
