//
//  YHBasicInfoFillModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHBasicInfoFillModel: SmartCodable {
    
    var applicant: ApplicantModel?
    var spouse: SpouseModel?
    var child: [SpouseModel]?
    var brother: [SpouseModel]?
    var background: BackgroundModel?
    var order_id: String = ""
    
    required init() {
        
    }
}

class BackgroundModel: SmartCodable {
    var subset: [SubsetModel] = []
    var background_member: BackgroundMemberModel?
    
    required init() {
        
    }
}

class SubsetModel: SmartCodable {
    var id: Int = 0
    var subset_name: String = ""
    
    required init() {
        
    }
}

class BackgroundMemberModel: SmartCodable {
    var has: String = ""
    var info: String = ""
    
    required init() {
        
    }
}

class SpouseModel: SmartCodable {
    var id: Int = 0
    var subset_name: String = ""
    var child_departure: BackgroundMemberModel?
    var child_deny: BackgroundMemberModel?
    required init() {
        
    }
}

class ApplicantModel: SmartCodable {
    var id: Int = 0
    var has_conviction: BackgroundMemberModel?
    var has_departure: BackgroundMemberModel?
    var has_deny: BackgroundMemberModel?
    var has_breaking_law: BackgroundMemberModel?
    var has_other_id: BackgroundMemberModel?
    
    required init() {
        
    }
    
}
