//
//  YHBasicInfoFillBottomView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/3.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHBasicInfoFillBottomView: UIView {
    static let viewH: CGFloat = 98.0
    
    override init(frame: CGRect) {
        super.init(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: YHBasicInfoFillBottomView.viewH))
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    typealias Block = (Int) -> Void
    var block: Block?
    var saveButton: UIButton!
    var nextButton: UIButton!
}

private extension YHBasicInfoFillBottomView {
    func setupUI() {
        
        backgroundColor = .white
        
        saveButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.contentBkgColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("保存", for: .normal)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(save), for: .touchUpInside)
            return button
        }()
        addSubview(saveButton)
        saveButton.snp.makeConstraints { make in
            make.left.equalTo(kMargin)
            make.top.equalTo(10)
            make.height.equalTo(44)
            make.width.equalTo(86)
        }
        
        nextButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("提交", for: .normal)
            button.setTitleColor(.white, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(submit), for: .touchUpInside)
            return button
        }()
        addSubview(nextButton)
        nextButton.snp.makeConstraints { make in
            make.right.equalTo(-kMargin)
            make.top.equalTo(10)
            make.height.equalTo(44)
            make.left.equalTo(saveButton.snp.right).offset(10)
        }
        
        nextButton.layoutIfNeeded()
        nextButton.addYinHeGradualLayer()
    }
    
    @objc func save() {
        block?(0)
    }
    @objc func submit() {
        block?(1)
    }
}
