//
//  YHCertificateUploadVC.swift
//  galaxy
//
//  Created by edy on 2024/2/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCertificateUploadVC: YHBaseViewController, YHFamilyMemberProtol {

    var tableView: UITableView!
    weak var delegate: YHSpouseInfoVCProtocol?

    var familyMember: YHFamilyMember? {
        didSet {
            if let familyMember = familyMember {
                viewModel.familyMemberModel = familyMember
            }
        }
    }
    var mainApplicantInfo: YHMyMainApplicantInfoModel? {
        didSet {
            if let mainApplicantInfo = mainApplicantInfo {
                viewModel.mainApplicantInfo = mainApplicantInfo
            }
        }
    }

    lazy var viewModel: YHFamilyMemberViewModel = {
        let model = YHFamilyMemberViewModel()
        model.saveInfoSilentBlock = {
            if let delegate = self.delegate, delegate.responds(to: #selector(YHSpouseInfoVCProtocol.saveInfoSilent)) {
                delegate.saveInfoSilent()
            }
        }
        return model
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = UIColor(hexString: "#F8F8F8")
        gk_navigationBar.isHidden = true
        createUI()
    }
    
    func loadInfo() {
        self.tableView.reloadData()
    }
    
    func nextStep() -> Bool {
        return true
    }
    
    func createUI() {
        
        tableView = {
            let tableView = UITableView(frame: .zero, style: .plain)
            if #available(iOS 11.0, *) {
                tableView.contentInsetAdjustmentBehavior = .never
            }
            tableView.backgroundColor = UIColor(hexString: "#F8F8F8")
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.register(cellWithClass: YHIdentityCardCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        
        let topHeight = k_Height_NavigationtBarAndStatuBar+YHStepView.height
        let bottomHeight = YHSaveAndSubmitView.height
        tableView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalToSuperview()
            make.right.equalToSuperview()
            make.height.equalTo(KScreenHeight-topHeight-bottomHeight)
        }
    }
}

extension YHCertificateUploadVC: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return viewModel.getIDCardDataSource(false).count
    }
 
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        let cell = tableView.dequeueReusableCell(withClass: YHIdentityCardCell.self)
        let dataSource = viewModel.getIDCardDataSource(false)

        if indexPath.row < dataSource.count {
            if dataSource[indexPath.row].models?.first?.id == .id5 {
                cell.type = .identity
            }
            if dataSource[indexPath.row].models?.first?.id == .id6 {
                cell.type = .passport
            }
            if dataSource[indexPath.row].models?.first?.id == .id7 {
                cell.type = .other
            }
            cell.viewModel = viewModel
            cell.backSurfaceDeleteButton.isHidden = true
            cell.frontDeleteButton.isHidden = true
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 219
    }
}
