//
//  YHFormAddInfoCell.swift
//  galaxy
//
//  Created by edy on 2024/1/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFormItemAddCell: UITableViewCell {

    static let cellReuseIdentifier = "YHFormItemAddCell"

    let btnTitleColor: UIColor = .brandMainColor
    let cornerRadius = 4.0
    let horizonalGap = 18.0

    let btnSize = CGSize(width: (KScreenWidth-(18+16)*2), height: 44)
    
    var clickBlock: (() -> Void)?
    
    var title: String? {
        didSet {
            addBtn.setTitle(title, for: .normal)
        }
    }
    
    lazy var addBtn: UIButton = {
        let btn = UIButton()
        btn.setTitle("新增信息".local, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
        btn.setTitleColor(btnTitleColor, for: .normal)
        btn.iconInLeft(spacing: 6)
        btn.setImage(UIImage(named: "form_add_info")?.withRenderingMode(.alwaysTemplate), for: .normal)
        btn.tintColor = .brandMainColor
        btn.addTarget(self, action: #selector(didClickAddBtn), for: .touchUpInside)
        return btn
    }()
    
    private lazy var topLine: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        view.isHidden = true
        return view
    }()
    
    var isNeedTopLineNoGap: Bool = false {
        didSet {
            let margin = isNeedTopLineNoGap ? 0 : horizonalGap
            topLine.snp.updateConstraints { make in
                make.left.equalToSuperview().offset(margin)
                make.right.equalToSuperview().offset(-margin)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    // 是否隐藏顶部分割线
    var isHiddenTopLine: Bool = true {
        didSet {
            topLine.isHidden = isHiddenTopLine
        }
    }
    
    lazy var dotLineLayer: CAShapeLayer = {
        
        let borderLayer =  CAShapeLayer()
        borderLayer.path = UIBezierPath(roundedRect: CGRect(x: 0, y: 0, width: btnSize.width, height: btnSize.height), cornerRadius: cornerRadius).cgPath
        borderLayer.lineWidth = 0.5
        // [数组第一个数字表示单个虚线长度，第二个数字表示间隔]
        borderLayer.lineDashPattern = [2, 2]  as [NSNumber]?
        // 前边是虚线的长度，后边是虚线之间空隙的长度
        borderLayer.lineDashPhase = 0.1
        // 实线边框
        borderLayer.fillColor = UIColor.clear.cgColor
        borderLayer.strokeColor = btnTitleColor.cgColor
        return borderLayer
        
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white

        contentView.addSubview(addBtn)
        addBtn.layer.addSublayer(dotLineLayer)
        contentView.addSubview(topLine)

        addBtn.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(horizonalGap)
            make.bottom.equalToSuperview().offset(-horizonalGap)
            make.size.equalTo(btnSize)
            make.centerX.equalToSuperview()
        }
        
        topLine.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalToSuperview().offset(-horizonalGap)
            make.height.equalTo(1.0)
            make.top.equalToSuperview()
        }
    }
    
    @objc func didClickAddBtn() {
     
        if let clickBlock = clickBlock {
            clickBlock()
        }
    }
}
