//
//  YHFormItemOnlyDoubleChoiceCell.swift
//  galaxy
//
//  Created by edy on 2024/1/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFormItemOnlyDoubleChoiceCell: UITableViewCell {

    static let cellReuseIdentifier = "YHFormItemOnlyDoubleChoiceCell"
    let horizonalGap = 18.0
    let btnWidth = 70.0
    let btnHeight = 32.0
    let btnTitleSelectColor = UIColor.brandMainColor
    let btnTitleDefaultColor = UIColor.mainTextColor
    let btnBgDefaultColor = UIColor(hex: 0xF8F9FB)
    let btnBgSelectColor = UIColor.brandMainColor8
    let answerBaseTag  = 9527
    
    var answerBlock: (([YHFormChoiceItem], Int) -> Void)?
    
    // 必须传2个item的arr
    var answerArr: [YHFormChoiceItem]? {
        didSet {
            if let answerArr = answerArr, answerArr.count == 2 {
                
                for i in 0...1 {
                    guard let answerBtn = self.viewWithTag(answerBaseTag+i) as? UIButton else { return }
                    let item = answerArr[i]
                    answerBtn.setTitle(item.title, for: .normal)
                    updateAnswerButton(answerBtn, item.isSelect)
                }
            } else {
                // 重置所有答案状态
                for i in 0...1 {
                    guard let answerBtn = self.viewWithTag(answerBaseTag+i) as? UIButton else { return }
                    answerBtn.setTitle("", for: .normal)
                    updateAnswerButton(answerBtn, false)
                }
            }
        }
    }
    
    private lazy var topLine: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    // 更新答案按钮选中状态
    func updateAnswerButton(_ btn: UIButton, _ isSelect: Bool) {
        btn.layer.borderColor = (isSelect ? btnTitleSelectColor : .clear).cgColor
        btn.setTitleColor((isSelect ? btnTitleSelectColor : btnTitleDefaultColor), for: .normal)
        btn.backgroundColor = (isSelect ? btnBgSelectColor : btnBgDefaultColor)
    }
    
    lazy var answer1Btn: UIButton = {
        
        let btn = UIButton()
        btn.setTitle("", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(btnTitleDefaultColor, for: .normal)
        btn.backgroundColor = btnBgDefaultColor
        btn.layer.cornerRadius = btnHeight/2.0
        btn.layer.masksToBounds = true
        btn.layer.borderWidth = 1
        btn.layer.borderColor = UIColor.clear.cgColor
        btn.tag = answerBaseTag
        btn.addTarget(self, action: #selector(didClickResponseBtn(btn:)), for: .touchUpInside)
        return btn
    }()
    
    lazy var answer2Btn: UIButton = {
        let btn = UIButton()
        btn.setTitle("", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(btnTitleDefaultColor, for: .normal)
        btn.backgroundColor = btnBgDefaultColor
        btn.layer.cornerRadius = btnHeight/2.0
        btn.layer.masksToBounds = true
        btn.layer.borderWidth = 1
        btn.layer.borderColor = UIColor.clear.cgColor
        btn.tag = answerBaseTag+1
        btn.addTarget(self, action: #selector(didClickResponseBtn(btn:)), for: .touchUpInside)
        return btn
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white

        contentView.addSubview(answer1Btn)
        contentView.addSubview(answer2Btn)
        contentView.addSubview(topLine)
        
        answer1Btn.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.bottom.equalTo(-16)
            make.size.equalTo(CGSize(width: btnWidth, height: btnHeight))
            make.left.equalToSuperview().offset(16)
        }
        
        answer2Btn.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: btnWidth, height: btnHeight))
            make.left.equalTo(answer1Btn.snp.right).offset(10)
            make.centerY.equalTo(answer1Btn)
        }
        
        topLine.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalToSuperview().offset(-horizonalGap)
            make.height.equalTo(1.0)
            make.top.equalToSuperview()
        }
    }
    
    @objc func didClickResponseBtn(btn: UIButton) {
        
        let selectIndex = btn.tag-answerBaseTag
        if let resultArr = answerArr, resultArr.count == 2 {
            
            for i in 0...1 {
                let item = resultArr[i]
                item.isSelect = (i == selectIndex)
            }
            answerArr = resultArr
            if let answerBlock = answerBlock {
                answerBlock(resultArr, selectIndex)
            }
        }
    }
}
