//
//  YHFormItemQuestionsCell.swift
//  galaxy
//
//  Created by edy on 2024/2/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFormItemQuestionsCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHFormItemQuestionsCell"
    let horizonalGap = 18.0
    private let btnWidth = 70.0
    private let btnHeight = 32.0
    private let btnTitleSelectColor = UIColor.brandMainColor
    private let btnTitleDefaultColor = UIColor.mainTextColor
    private let btnBgDefaultColor = UIColor.contentBkgColor
    private let btnBgSelectColor = UIColor.brandMainColor.withAlphaComponent(0.08)
    private let answerBaseTag  = 9527
    
    // 是否必须字段
    var isMust: Bool = false
    var answerBlock: (([YHFormChoiceItem], Int) -> Void)?
    
    var title: String? {
        didSet {
            
            if let title = title, !title.isEmpty {
                let str = (isMust ? ("*"+title) : title)
                let attributes: [NSAttributedString.Key: Any] = [
                    .font: UIFont.PFSC_R(ofSize: 14),
                    .foregroundColor: UIColor.mainTextColor]
                let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
                if isMust {
                    let starRange = NSRange(location: 0, length: 1)
                    questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
                }
                
                titleLabel.attributedText = questionAttrStr
            } else {
                titleLabel.attributedText = nil
            }
        }
    }
    
    // 必须传2个item的arr
    var answerArr: [YHFormChoiceItem]? {
        didSet {
            if let answerArr = answerArr, answerArr.count == 2 {
                
                for i in 0...1 {
                    guard let answerBtn = self.viewWithTag(answerBaseTag+i) as? UIButton else { return }
                    let item = answerArr[i]
                    answerBtn.setTitle(item.title, for: .normal)
                    updateAnswerButton(answerBtn, item.isSelect)
                }
            } else {
                // 重置所有答案状态
                for i in 0...1 {
                    guard let answerBtn = self.viewWithTag(answerBaseTag+i) as? UIButton else { return }
                    answerBtn.setTitle("", for: .normal)
                    updateAnswerButton(answerBtn, false)
                }
            }
        }
    }
    
    // 是否隐藏顶部分割线
    var isHiddenTopLine: Bool = false {
        didSet {
            topLine.isHidden = isHiddenTopLine
        }
    }
    
    // 更新答案按钮选中状态
    private func updateAnswerButton(_ btn: UIButton, _ isSelect: Bool) {
        btn.layer.borderColor = (isSelect ? btnTitleSelectColor : .clear).cgColor
        btn.setTitleColor((isSelect ? btnTitleSelectColor : btnTitleDefaultColor), for: .normal)
        btn.backgroundColor = (isSelect ? btnBgSelectColor : btnBgDefaultColor)
    }
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var answer1Btn: UIButton = {
        
        let btn = UIButton()
        btn.setTitle("", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(btnTitleDefaultColor, for: .normal)
        btn.backgroundColor = btnBgDefaultColor
        btn.layer.cornerRadius = btnHeight/2.0
        btn.layer.masksToBounds = true
        btn.layer.borderWidth = 1
        btn.layer.borderColor = UIColor.clear.cgColor
        btn.tag = answerBaseTag
        btn.addTarget(self, action: #selector(didClickResponseBtn(btn:)), for: .touchUpInside)
        return btn
    }()
    
    private lazy var answer2Btn: UIButton = {
        let btn = UIButton()
        btn.setTitle("", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(btnTitleDefaultColor, for: .normal)
        btn.backgroundColor = btnBgDefaultColor
        btn.layer.cornerRadius = btnHeight/2.0
        btn.layer.masksToBounds = true
        btn.layer.borderWidth = 1
        btn.layer.borderColor = UIColor.clear.cgColor
        btn.tag = answerBaseTag+1
        btn.addTarget(self, action: #selector(didClickResponseBtn(btn:)), for: .touchUpInside)
        return btn
    }()
    
    private lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.textColor = .failColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.isHidden = true
        return label
    }()
    
    private lazy var topLine: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white

        contentView.addSubview(titleLabel)
        contentView.addSubview(answer2Btn)
        contentView.addSubview(answer1Btn)
        contentView.addSubview(tipsLabel)
        contentView.addSubview(topLine)
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(contentView.snp.top).offset(22)
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.bottom.equalTo(answer1Btn.snp.top).offset(-16)
        }
        
        answer1Btn.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: btnWidth, height: btnHeight))
            make.left.equalTo(titleLabel)
            make.bottom.equalToSuperview().offset(-16)
        }
        
        answer2Btn.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: btnWidth, height: btnHeight))
            make.left.equalTo(answer1Btn.snp.right).offset(16)
            make.centerY.equalTo(answer1Btn)
        }
        
        topLine.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(horizonalGap)
            make.right.equalToSuperview().offset(-horizonalGap)
            make.height.equalTo(1.0)
            make.top.equalToSuperview()
        }
        
        setTips("", isShow: false)
    }
    
    func setTips(_ tips: String?, isShow: Bool) {
        tipsLabel.text = tips
        tipsLabel.isHidden = !isShow
        if isShow {
            tipsLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(horizonalGap)
                make.right.equalToSuperview().offset(-horizonalGap)
                make.top.equalTo(answer1Btn.snp.bottom)
                make.bottom.equalToSuperview().offset(-16)
            }
        } else {
            tipsLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(horizonalGap)
                make.right.equalToSuperview().offset(-horizonalGap)
                make.top.equalTo(answer1Btn.snp.bottom)
                make.height.equalTo(0)
                make.bottom.equalToSuperview().offset(-16)
            }
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
    
    @objc func didClickResponseBtn(btn: UIButton) {
        
        let selectIndex = btn.tag-answerBaseTag
        if let resultArr = answerArr, resultArr.count == 2 {
            
            for i in 0...1 {
                let item = resultArr[i]
                item.isSelect = (i == selectIndex)
            }
            answerArr = resultArr
            if let answerBlock = answerBlock {
                answerBlock(resultArr, selectIndex)
            }
        }
    }
}
