//
//  YHIncomeRecordItemCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHIncomeRecordItemCell: YHResignDocumentCell {
    var deleteButtonClickEvent: (() -> Void)?
    static let cellReuseIdentifier = "YHIncomeRecordItemCell"
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_B(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "收入信息1"
        return label
    }()

    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = UIColor(hexString: "#8993A2")
        return label
    }()
    
    private lazy var rightLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = UIColor(hexString: "#8993A2")
        return label
    }()
    
    private lazy var rightArrowIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "form_right_arrow"))
        return imageView
    }()

    private lazy var deleteButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setTitle("删除", for: .normal)
        button.setTitleColor(UIColor.failColor, for: .normal)
        button.titleLabel?.font = .PFSC_R(ofSize: 14)
        button.addTarget(self, action: #selector(deleteButtonDidClick(_:)), for: .touchUpInside)
        return button
    }()

    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, detail: String, rightText: String, isEditing: Bool, showBottomLine: Bool, needHideDetail: Bool = false) {
        infoTitleLabel.text = title
        infoDetailLabel.text = detail
        rightLabel.text = rightText
        if isEditing {
            rightLabel.isHidden = true
            rightArrowIcon.isHidden = true
            deleteButton.isHidden = false
        } else {
            rightLabel.isHidden = false
            rightArrowIcon.isHidden = false
            deleteButton.isHidden = true
        }
        
        bottomLineView.isHidden = !showBottomLine
    }
}

extension YHIncomeRecordItemCell {
    @objc private func deleteButtonDidClick(_ sender: UIButton) {
        deleteButtonClickEvent?()
    }

    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(deleteButton)
        subContainerView.addSubview(rightArrowIcon)
        subContainerView.addSubview(rightLabel)
        subContainerView.addSubview(bottomLineView)
        
        infoTitleLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        deleteButton.setContentCompressionResistancePriority(.required, for: .horizontal)
        rightArrowIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        rightLabel.setContentCompressionResistancePriority(.defaultHigh, for: .horizontal)
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(16)
        }
        
        deleteButton.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-18)
            make.centerY.equalTo(infoTitleLabel)
            make.width.equalTo(28)
            make.height.equalTo(20)
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(10)
        }
        
        rightArrowIcon.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-18)
            make.width.height.equalTo(20)
            make.centerY.equalTo(infoTitleLabel)
        }
        
        rightLabel.snp.makeConstraints { make in
            make.right.equalTo(rightArrowIcon.snp.left).offset(-2)
            make.centerY.equalTo(infoTitleLabel)
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(10)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.left.equalTo(infoTitleLabel.snp.left)
            make.top.equalTo(infoTitleLabel.snp.bottom).offset(2)
            make.right.lessThanOrEqualToSuperview().offset(-18)
        }

        bottomLineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(0.5)
            make.top.equalTo(infoDetailLabel.snp.bottom).offset(16)
        }
    }
}
