//
//  YHIncomeRemarkCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHIncomeRemarkCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHIncomeRemarkCell"
    
    private lazy var containerView: YHBaseDynamicCornerRadiusView = {
        let view = YHBaseDynamicCornerRadiusView(cornerRadius: 3, corner: .allCorners)
        view.backgroundColor = UIColor(hexString: "#F5F6F8")
        return view
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = UIColor(hexString: "#8993A2")
        label.text = "注：按1港币≈0.92人民币计算，实际金额按递交时入境处给出的汇率为准"
        label.numberOfLines = 0
        label.lineBreakMode = .byWordWrapping
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(_ detail: String) {
        infoDetailLabel.text = detail
    }

}

extension YHIncomeRemarkCell {
    private func setupUI() {
        updateCellCorner(.bottom)
        subContainerView.addSubview(containerView)
        containerView.addSubview(infoDetailLabel)
        
        containerView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview()
            make.right.equalToSuperview().offset(-18)
            make.bottom.equalToSuperview().offset(-16)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(8)
            make.left.equalToSuperview().offset(10)
            make.right.equalToSuperview().offset(-10)
            make.bottom.equalToSuperview().offset(-8)
        }
    }
}
