//
//  YHIncomeTypeSelectCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import AttributedString
import UIKit

class YHIncomeTypeSelectCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHIncomeTypeSelectCell"
    private lazy var dotIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "red_dot_6"))
        return imageView
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "收入类型(多选)"
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = UIColor(hexString: "#B9C1CC")
        label.text = "请选择"
        return label
    }()
    
    private lazy var rightArrowIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "form_right_arrow"))
        return imageView
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()
    
    private lazy var infoFailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = .failColor
        label.text = "请选择"
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, detail: String = "请选择", isSelectedOne: Bool = false, showBottomLine: Bool = false, needShowFailButton: Bool) {
        infoTitleLabel.text = title
        infoDetailLabel.text = detail
        infoDetailLabel.isHidden = isSelectedOne
        bottomLineView.isHidden = !showBottomLine
        updateFailLabel(needShowFailButton)
    }

}

extension YHIncomeTypeSelectCell {
    private func updateFailLabel(_ needShowFailButton: Bool) {
        if needShowFailButton {
            infoDetailLabel.snp.remakeConstraints { make in
                make.top.equalToSuperview().offset(16)
                make.left.equalToSuperview().offset(147)
                make.right.lessThanOrEqualTo(rightArrowIcon.snp.left).offset(-18)
            }
            
            infoFailLabel.snp.remakeConstraints { make in
                make.top.equalTo(infoDetailLabel.snp.bottom).offset(6)
                make.left.equalTo(dotIcon)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
            infoFailLabel.isHidden = false
        } else {
            infoDetailLabel.snp.remakeConstraints { make in
                make.top.equalToSuperview().offset(16)
                make.bottom.equalToSuperview().offset(-16)
                make.left.equalToSuperview().offset(147)
                make.right.lessThanOrEqualTo(rightArrowIcon.snp.left).offset(-18)
            }
            
            infoFailLabel.snp.remakeConstraints { make in
                make.left.equalTo(dotIcon)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
            infoFailLabel.isHidden = true
        }
    }
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(dotIcon)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(rightArrowIcon)
        subContainerView.addSubview(bottomLineView)
        subContainerView.addSubview(infoFailLabel)
        
        dotIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoTitleLabel.setContentCompressionResistancePriority(.defaultHigh, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        rightArrowIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        dotIcon.snp.makeConstraints { make in
            make.centerY.equalTo(infoTitleLabel)
            make.left.equalToSuperview().offset(18)
            make.width.height.equalTo(6)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.left.equalTo(dotIcon.snp.right).offset(2)
        }
        
        rightArrowIcon.snp.makeConstraints { make in
            make.centerY.equalTo(infoTitleLabel)
            make.right.equalToSuperview().offset(-18)
            make.width.height.equalTo(20)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-16)
            make.left.equalToSuperview().offset(147)
            make.right.lessThanOrEqualTo(rightArrowIcon.snp.left).offset(-18)
        }
        
        infoFailLabel.snp.remakeConstraints { make in
            make.left.equalTo(dotIcon)
            make.right.lessThanOrEqualToSuperview().offset(-18)
            make.bottom.equalToSuperview().offset(-16)
        }
        infoFailLabel.isHidden = true
        
        bottomLineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(0.5)
        }
    }
}
