//
//  YHWorkingHourHeaderCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/14.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkingHourHeaderCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHWorkingHourHeaderCell"
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 17)
        label.textColor = UIColor.mainTextColor
        label.text = "工作时间说明"
        return label
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(_ title: String) {
        infoTitleLabel.text = title
    }

}

extension YHWorkingHourHeaderCell {
    private func setupUI() {
        updateCellCorner(.top)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(bottomLineView)
        
        infoTitleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.left.equalToSuperview().offset(18)
            make.right.lessThanOrEqualToSuperview().offset(-18)
        }
        
        bottomLineView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
            make.top.equalTo(infoTitleLabel.snp.bottom).offset(12)
            make.bottom.equalToSuperview()
        }
    }
}
