//
//  YHDatePickView.swift
//  galaxy
//
//  Created by EDY on 2024/1/30.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

/*
let addressPicker = YHAddressViewController( selectProvince: "上海市", selectCity: "" )
/*** 可使用这种init方法自定制选中颜色,不填写selectColor默认颜色为UIColor(red: 79/255, green: 176/255, blue: 255/255, alpha: 1),蓝色
let addressPicker = EWAddressViewController(selectColor: UIColor.yellow)
 */
// 返回选择数据,地址,省,市,区
addressPicker.backLocationStringController = { (address,province,city,area) in
}
self.present(addressPicker, animated: true, completion: nil)
*/

import UIKit
/// 默认选中颜色
let defaultColor = UIColor(red: 79/255, green: 176/255, blue: 255/255, alpha: 1)

class YHAddressViewController: UIViewController {

    public var backLocationStringController: ((String, String, String, String) -> Void)?
    /// title选中颜色
    public var selectColor: UIColor
    public var selectProvince: String?
    public var selectCity: String?

    public lazy var containV: YHAddressPickView = {
        let view = YHAddressPickView(frame: CGRect(x: 0, y: UIScreen.main.bounds.height - 628, width: UIScreen.main.bounds.width, height: 628), selectColor: selectColor, selectedProvince: selectProvince, selectedCity: selectCity)
        view.backOnClickCancel = {
            [weak self] in
            self?.onClickCancel()
        }
        /// 成功选择后将数据回调,并推出视图
        view.backLocationString = {[weak self] (address, province, city, area) in
            if self?.backLocationStringController != nil {
                self?.backLocationStringController!(address, province, city, area)
                self?.onClickCancel()
            }
        }
        view.layer.cornerRadius = kCornerRadius8
        return view
    }()
    public var backgroundView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(red: 0, green: 0, blue: 0, alpha: 0.4)
        return view
    }()

    init(selectColor: UIColor = defaultColor, selectProvince: String? = nil, selectCity: String? = nil) {
        self.selectColor = selectColor
        self.selectProvince = selectProvince
        self.selectCity = selectCity
        super.init(nibName: nil, bundle: nil)
        self.view.backgroundColor = UIColor(red: 0, green: 0, blue: 0, alpha: 0.3)
    }
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        drawMyView()
        // Do any additional setup after loading the view.
    }
    private func drawMyView() {
        self.view.insertSubview(self.backgroundView, at: 0)
        self.providesPresentationContextTransitionStyle = true
        self.definesPresentationContext = true
        self.modalPresentationStyle = .custom// viewcontroller弹出后之前控制器页面不隐藏 .custom代表自定义
        self.view.addSubview(self.containV)
        // 转场动画代理
        self.transitioningDelegate = self
    }

    /// 点击推出
    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
        super.touchesBegan(touches, with: event)
        let currentPoint = touches.first?.location(in: self.view)
        if !self.containV.frame.contains(currentPoint ?? CGPoint()) {
            self.dismiss(animated: true, completion: nil)
        }
    }

    // MARK: onClick
    @objc private func onClickCancel() {
        self.dismiss(animated: true, completion: nil)
    }

}
// MARK: - 转场动画delegate
extension YHAddressViewController: UIViewControllerTransitioningDelegate {
    /// 推入动画
    func animationController(forPresented presented: UIViewController, presenting: UIViewController, source: UIViewController) -> UIViewControllerAnimatedTransitioning? {
        let animated = YHAddressPickerPresentAnimated(type: .present)
        return animated
    }
    /// 推出动画
    func animationController(forDismissed dismissed: UIViewController) -> UIViewControllerAnimatedTransitioning? {
        let animated = YHAddressPickerPresentAnimated(type: .dismiss)
        return animated
    }
}
