//
//  YHOtherInfoFillCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHOtherInfoFillCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHOtherInfoFillCell"
    
    typealias Block = () -> Void
    var block: Block?
    
    var dataModel: YHOtherInfoFillModel? {
        didSet {
            updateUI()
        }
    }
    
    lazy var addBtn: UIButton = {
        let btn = UIButton()
        btn.setTitle("新增居住信息".local, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
        btn.setTitleColor(UIColor.brandMainColor, for: .normal)
        btn.iconInLeft(spacing: 6)
        btn.setImage(UIImage(named: "form_add_info")?.withRenderingMode(.alwaysTemplate), for: .normal)
        btn.tintColor = .brandMainColor
        btn.addTarget(self, action: #selector(didClickAddBtn), for: .touchUpInside)
        return btn
    }()
    
    lazy var dotLineLayer: CAShapeLayer = {
        
        let borderLayer =  CAShapeLayer()
        borderLayer.position = CGPoint(x: addBtn.bounds.midX, y: addBtn.bounds.midY)
        borderLayer.path = UIBezierPath(roundedRect: borderLayer.bounds, cornerRadius: addBtn.layer.cornerRadius).cgPath
        borderLayer.lineWidth = 0.5
        // [数组第一个数字表示单个虚线长度，第二个数字表示间隔]
        borderLayer.lineDashPattern = [2, 2]  as [NSNumber]?
        // 前边是虚线的长度，后边是虚线之间空隙的长度
        borderLayer.lineDashPhase = 0.1
        // 实线边框
        borderLayer.fillColor = UIColor.clear.cgColor
        borderLayer.strokeColor = UIColor.brandMainColor.cgColor
        return borderLayer
        
    }()
    
    let languageView = YHOtherSelecteItemView()
    let skillView = YHOtherSelecteItemView()
    
    private lazy var languageViewNew: YHOtherLanguageSelecteView = {
        let view = YHOtherLanguageSelecteView()
        return view
    }()
}

extension YHOtherInfoFillCell {
    @objc func didClickAddBtn() {
        printLog("点击了 添加按钮")
        
        let model = Residence()
        dataModel?.residences.append(model)
        self.block?()
    }
    
    func updateUI() {
        guard let dataModel = dataModel else { return}
        contentView.removeSubviews()
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        
//        //1.居住信息
//        let holdView1 = createHoldView()
//        contentView.addSubview(holdView1)
//        holdView1.snp.makeConstraints { make in
//            make.top.left.right.equalToSuperview()
//        }
//        
//        do {
//            
//            var lastTargetView : UIView!
//            if dataModel.residences.count > 1 {
//                for (index,item) in dataModel.residences.enumerated() {
//                    if index == 0 {
//                        let sessionView = YHOtherInfoSessionView(frame: .zero)
//                        sessionView.type = 3
//                        sessionView.updateTitle(title: "居住信息")
//                        holdView1.addSubview(sessionView)
//                        sessionView.snp.makeConstraints { make in
//                            make.top.equalToSuperview()
//                            make.left.equalToSuperview().offset(18)
//                            make.right.equalToSuperview().offset(-18)
//                            make.height.equalTo(YHOtherInfoSessionView.viewH)
//                        }
//                        
//                        let residenceView = YHOtherResidenceFillView(frame: .zero)
//                        item.needCheckFlag = dataModel.needCheckFlag
//                        residenceView.dataModel = item
//                        holdView1.addSubview(residenceView)
//                        
//                        residenceView.snp.makeConstraints { make in
//                            make.top.equalTo(sessionView.snp.bottom)
//                            make.left.equalToSuperview().offset(18)
//                            make.right.equalToSuperview().offset(-18)
//                        }
//                        
//                        lastTargetView = residenceView
//                    } else {
//                        let sessionView = YHOtherInfoSessionView(frame: .zero)
//                        
//                        let addationIndex = dataModel.residences.count > 1 ? String(index + 1) : ""
//                        let title = "居住信息" + addationIndex
//                        sessionView.updateTitle(title: title)
//                        sessionView.type = 1
//                        sessionView.tag = index
//                        sessionView.block = { tag in
//                            if tag < dataModel.residences.count  {
//                                dataModel.residences.remove(at: tag)
//                                self.block?()
//                            }
//                        }
//                        
//                        holdView1.addSubview(sessionView)
//                        sessionView.snp.makeConstraints { make in
//                            make.top.equalTo(lastTargetView.snp.bottom).offset(kMargin)
//                            make.left.equalToSuperview().offset(18)
//                            make.right.equalToSuperview().offset(-18)
//                            make.height.equalTo(YHOtherInfoSessionView.viewH)
//                        }
//                        
//                        let residenceView = YHOtherResidenceFillView(frame: .zero)
//                        item.needCheckFlag = dataModel.needCheckFlag
//                        residenceView.dataModel = item
//                        holdView1.addSubview(residenceView)
//                        residenceView.snp.makeConstraints { make in
//                            make.top.equalTo(sessionView.snp.bottom)
//                            make.left.equalToSuperview().offset(18)
//                            make.right.equalToSuperview().offset(-18)
//                        }
//                        
//                        lastTargetView = residenceView
//                    }
//                }
//            } else {
//                
//                let sessionView = YHOtherInfoSessionView(frame: .zero)
//                sessionView.type = 3
//                sessionView.updateTitle(title: "居住信息")
//                holdView1.addSubview(sessionView)
//                sessionView.snp.makeConstraints { make in
//                    make.top.equalToSuperview()
//                    make.left.equalToSuperview().offset(18)
//                    make.right.equalToSuperview().offset(-18)
//                    make.height.equalTo(YHOtherInfoSessionView.viewH)
//                }
//                
//                let residenceView = YHOtherResidenceFillView(frame: .zero)
//                if dataModel.residences.count > 0 {
//                    let item = dataModel.residences[0]
//                    item.needCheckFlag = dataModel.needCheckFlag
//                    residenceView.dataModel = item
//                } else {
//                    printLog("error: 数据源有问题")
//                }
//                
//                holdView1.addSubview(residenceView)
//                residenceView.snp.makeConstraints { make in
//                    make.top.equalTo(sessionView.snp.bottom)
//                    make.left.equalToSuperview().offset(18)
//                    make.right.equalToSuperview().offset(-18)
//                }
//                
//                lastTargetView = residenceView
//            }
//            
//            //添加按钮
//            holdView1.addSubview(addBtn)
//            addBtn.layer.addSublayer(dotLineLayer)
//            
//            
//            addBtn.snp.makeConstraints { make in
//                make.top.equalTo(lastTargetView.snp.bottom).offset(kMargin)
//                make.left.equalToSuperview().offset(18)
//                make.right.equalToSuperview().offset(-18)
//                make.height.equalTo(44)
//                
//                make.bottom.equalToSuperview().offset(-18).priority(.high)
//            }
//            addBtn.layoutIfNeeded()
//            dotLineLayer.path = UIBezierPath(roundedRect: CGRect(x: 0, y: 0, width: KScreenWidth - 18 * 2 - 16 * 2, height: 44), cornerRadius: kCornerRadius6).cgPath
//        }
//        holdView1.layoutIfNeeded()
        
        // 2.语言水平
        let holdView2 = createHoldView()
        contentView.addSubview(holdView2)
        holdView2.snp.makeConstraints { make in
//            make.top.equalTo(holdView1.snp.bottom).offset(18).priority(.low)
            make.top.equalToSuperview()
            make.left.right.equalToSuperview()
        }
        
        do {
            let sessionView = YHOtherInfoSessionView(frame: .zero)
            sessionView.updateTitle(title: "语言水平")
            holdView2.addSubview(sessionView)
            sessionView.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
                make.height.equalTo(YHOtherInfoSessionView.viewH)
            }
            
//            let view = languageView
//            view.updateKeyName(name: "您的语言水平与下列哪一项符合（多选）", keyValue:dataModel.language_detail?.levelDes ?? "",firstTxt: dataModel.language_detail?.name ?? "",secondTxt: dataModel.language_detail?.remark ?? "")
//            view.needCheckFlag = dataModel.needCheckFlag
//            view.type = 2
//            
//            view.textBlock = {firstTxt,secondTxt in
//                self.dataModel?.language_detail?.name = firstTxt
//                self.dataModel?.language_detail?.remark = secondTxt
//            }
//            
//            holdView2.addSubview(view)
//            view.snp.makeConstraints { make in
//                make.top.equalTo(sessionView.snp.bottom)
//                make.left.equalToSuperview().offset(18)
//                make.right.equalToSuperview().offset(-18)
//                
//                make.bottom.equalToSuperview()
//            }
            
//            let tap = UITapGestureRecognizer(target: self, action: #selector(tapViewItem))
//            view.addGestureRecognizer(tap)
            
            languageViewNew.needCheckFlag = dataModel.needCheckFlag
            languageViewNew.dataModel = dataModel.language_detail_new_data
            languageViewNew.block = { model in
                if let tmpModel = model {
                    
                    var targetIndex: Int = -1
                    for (index, item) in dataModel.language_detail_new_data.enumerated() {
                        if item.id == tmpModel.id {
                            targetIndex = index
                        }
                    }
                    
                    if targetIndex > -1, targetIndex < dataModel.language_detail_new_data.count {
                        dataModel.language_detail_new_data[targetIndex] = tmpModel
                    }
                    
                }
                self.block?()
            }
            
            holdView2.addSubview(languageViewNew)
            languageViewNew.snp.makeConstraints { make in
                make.top.equalTo(sessionView.snp.bottom)
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
                make.bottom.equalToSuperview()
            }
        }
        holdView2.layoutIfNeeded()
        
        // 3.专业技能行业
        let holdView3 = createHoldView()
        contentView.addSubview(holdView3)
        holdView3.snp.makeConstraints { make in
            make.top.equalTo(holdView2.snp.bottom).offset(18)
            make.left.right.equalToSuperview()
        }
        
        do {
            let sessionView = YHOtherInfoSessionView(frame: .zero)
            sessionView.updateTitle(title: "专业技能行业")
            holdView3.addSubview(sessionView)
            sessionView.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
                make.height.equalTo(YHOtherInfoSessionView.viewH)
            }
            
            let view = skillView
            view.updateKeyName(name: "最能代表你的专业技能的行业", keyValue: dataModel.profession?.optionDes ?? "", firstTxt: dataModel.profession?.remark ?? "")
            view.needCheckFlag = dataModel.needCheckFlag
            view.type = 2
            
            view.textBlock = { firstTxt, _ in
                self.dataModel?.profession?.remark = firstTxt
            }
            holdView3.addSubview(view)
            view.snp.makeConstraints { make in
                make.top.equalTo(sessionView.snp.bottom)
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
                make.bottom.equalToSuperview()
            }
            
            let tap = UITapGestureRecognizer(target: self, action: #selector(tapViewItem2))
            skillView.addGestureRecognizer(tap)
            
        }
        holdView3.layoutIfNeeded()
        
        // 4.辅助资料
        let holdView4 = createHoldView()
        contentView.addSubview(holdView4)
        holdView4.snp.makeConstraints { make in
            make.top.equalTo(holdView3.snp.bottom).offset(18)
            make.left.right.equalToSuperview()
            make.bottom.equalToSuperview().offset(-18)
        }
        
        do {
            let sessionView = YHOtherInfoSessionView(frame: .zero)
            sessionView.type = 2
            sessionView.updateTitle(title: "辅助资料")
            holdView4.addSubview(sessionView)
            sessionView.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
                make.height.equalTo(YHOtherInfoSessionView.viewH)
            }
            
            // 1、您是否有行业内的专业资格证书？
            let fzView1 = YHOtherYesOrNoItemView(frame: .zero)
            fzView1.updateUI(title: "1、您是否有行业内的专业资格证书？", answer: dataModel.question?.professional_qualification ?? -1)
            fzView1.needCheckFlag = dataModel.needCheckFlag
            fzView1.block = { answer in
                dataModel.question?.professional_qualification = answer
            }
            holdView4.addSubview(fzView1)
            fzView1.snp.makeConstraints { make in
                make.top.equalTo(sessionView.snp.bottom)
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
            }
            
            // 2、您是否在期刊或杂志上发表过论文、文章、书籍等（与工作、资质有关的）？
            let fzView2 = YHOtherYesOrNoItemView(frame: .zero)
            fzView2.updateUI(title: "2、您是否在期刊或杂志上发表过论文、文章、书籍等（与工作、资质有关的）？", answer: dataModel.question?.paper ?? -1)
            fzView2.needCheckFlag = dataModel.needCheckFlag
            fzView2.block = { answer in
                dataModel.question?.paper = answer
            }
            holdView4.addSubview(fzView2)
            fzView2.snp.makeConstraints { make in
                make.top.equalTo(fzView1.snp.bottom)
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
            }
            
            // 3、您是否有大学奖学金证明、专利证书、获奖证书（工作单位颁发的可以）？
            let fzView3 = YHOtherYesOrNoItemView(frame: .zero)
            fzView3.updateUI(title: "3、您是否有大学奖学金证明、专利证书、获奖证书（工作单位颁发的可以）？", answer: dataModel.question?.scholarship ?? -1)
            fzView3.needCheckFlag = dataModel.needCheckFlag
            fzView3.block = { answer in
                dataModel.question?.scholarship = answer
            }
            holdView4.addSubview(fzView3)
            fzView3.snp.makeConstraints { make in
                make.top.equalTo(fzView2.snp.bottom)
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
            }
            
            // 4、您是否被媒体采访过，专访您的文章被发表在杂志上或网络上？
            let fzView4 = YHOtherYesOrNoItemView(frame: .zero)
            fzView4.updateUI(title: "4、您是否被媒体采访过，专访您的文章被发表在杂志上或网络上？", answer: dataModel.question?.media_interview ?? -1)
            fzView4.needCheckFlag = dataModel.needCheckFlag
            fzView4.block = { answer in
                dataModel.question?.media_interview = answer
            }
            holdView4.addSubview(fzView4)
            fzView4.snp.makeConstraints { make in
                make.top.equalTo(fzView3.snp.bottom)
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
            }
            
            // 5、专业奖项
            let fzView5 = YHOtherTextViewItemView(frame: .zero)
            fzView5.updateUI(title: "5、专业奖项", value: dataModel.question?.professional_awards ?? "", type: .professionAwards)
            fzView5.block = { txt in
                dataModel.question?.professional_awards = txt
                
            }
            holdView4.addSubview(fzView5)
            fzView5.snp.makeConstraints { make in
                make.top.equalTo(fzView4.snp.bottom)
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
                make.height.equalTo(YHOtherTextViewItemView.viewH)
            }
            
            // 6、学业奖项
            let fzView6 = YHOtherTextViewItemView(frame: .zero)
            fzView6.updateUI(title: "6、学业奖项", value: dataModel.question?.academic_awards ?? "", type: .academicAwards)
            fzView6.block = { txt in
                dataModel.question?.academic_awards = txt
                
            }
            holdView4.addSubview(fzView6)
            fzView6.snp.makeConstraints { make in
                make.top.equalTo(fzView5.snp.bottom)
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
                make.height.equalTo(YHOtherTextViewItemView.viewH)
            }
            
            // 7、其他奖励
            let fzView7 = YHOtherTextViewItemView(frame: .zero)
            fzView7.updateUI(title: "7、其他资料", value: dataModel.question?.other_information ?? "", type: .otherAwards)
            fzView7.block = { txt in
                dataModel.question?.other_information = txt
            }
            holdView4.addSubview(fzView7)
            fzView7.snp.makeConstraints { make in
                make.top.equalTo(fzView6.snp.bottom)
                make.left.equalToSuperview().offset(18)
                make.right.equalToSuperview().offset(-18)
                make.height.equalTo(YHOtherTextViewItemView.viewH)
                make.bottom.equalToSuperview()
            }
        }
    }
    
    func createHoldView() -> UIView {
        let holdView1 = UIView()
        holdView1.backgroundColor = .white
        holdView1.layer.cornerRadius = kCornerRadius6
        holdView1.clipsToBounds = true
        return holdView1
    }
}

extension YHOtherInfoFillCell {
    @objc func tapViewItem(_ gestureRecognizer: UIPanGestureRecognizer) {
        YHOtherPickerView.show(type: .language, selectTitle: self.dataModel?.language_detail?.levelDes ?? "") { item in
            self.dataModel?.language_detail?.level = Int(item.index) ?? 0
            self.dataModel?.language_detail?.levelDes = item.title
            self.languageView.updateKeyName(name: "您的语言水平与下列哪一项符合", keyValue: self.dataModel?.language_detail?.levelDes ?? "")
            
            self.block?()
        }
    }
    
    @objc func tapViewItem2(_ gestureRecognizer: UIPanGestureRecognizer) {
        YHOtherPickerView.show(type: .professionalSkill, selectTitle: self.dataModel?.profession?.optionDes ?? "") { item in
            print(item)
            self.dataModel?.profession?.option = Int(item.index) ?? 0
            self.dataModel?.profession?.optionDes = item.title
            self.skillView.updateKeyName(name: "最能代表你的专业技能的行业", keyValue: self.dataModel?.profession?.optionDes ?? "")
            
            self.block?()
        }
    }
}
