//
//  YHOtherLanguageSelecteView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHOtherLanguageSelecteView: UIView {
    
    typealias Block = (LanguageDetailModel?) -> Void
    var block: Block?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    // 提示lable
    private lazy var noTextTipsLable: UILabel = {
        let label = UILabel()
        label.textColor = .failColor
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.text = "请选择"
        label.isHidden = true
        return label
    }()
    
    var mutilHoldView: UIView = {
        let view = UIView()
        return view
    }()
    
    //
    private var arrLanguage: [YHOtherMultipleChoiceItemView] = []
    private var arrLanguageOptions: [YHSingleOptionalItemsView] = []
    
    var needCheckFlag: Bool = false
//    {
//        didSet {
//            layoutIfNeeded()
//        }
//    }
    
    var dataModel: [LanguageDetailModel] = [] {
        didSet {
            updateUI()
        }
    }
    
//    override func layoutSubviews() {
//        super.layoutSubviews()
//        
//        updateUI()
//    }
    
}

extension YHOtherLanguageSelecteView {
    func setupUI() {
        noTextTipsLable.text = "请选择语言水平"
        
        let str = "* " + "您的语言水平与下列哪一项符合（多选）"
        let attributes: [NSAttributedString.Key: Any] = [
            .font: UIFont.PFSC_R(ofSize: 14),
            .foregroundColor: UIColor.mainTextColor
        ]
        let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
        let starRange = NSRange(location: 0, length: 1)
        questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
        titleLabel.attributedText = questionAttrStr
        
        addSubview(titleLabel)
        addSubview(mutilHoldView)
        addSubview(noTextTipsLable)
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(kMargin)
            make.left.right.equalToSuperview()
            make.height.equalTo(20)
        }
        
        mutilHoldView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(kMargin)
            make.right.equalToSuperview()
            make.left.equalToSuperview()
            
            make.bottom.equalToSuperview().offset(-kMargin)
        }
        
        // 初始化页面数据
        
        arrLanguage.removeAll()
        arrLanguageOptions.removeAll()
        
        if let arr = [LanguageDetailModel].deserialize(from: YHOtherInfoFillViewModel.languageJsonData), arr.count > 0 {
            
            var lastView: UIView?
            for (index, item) in arr.enumerated() {
                let tmpView = YHOtherMultipleChoiceItemView()
                tmpView.dataModel = item
                
                tmpView.block = { model in
                    self.block?(model)
                }
                
                mutilHoldView.addSubview(tmpView)
                arrLanguage.append(tmpView)
                
                if index == 0 {
                    // 第一个
                    tmpView.snp.makeConstraints { make in
                        make.top.left.right.equalToSuperview()
                        make.height.equalTo(YHOtherMultipleChoiceItemView.viewH)
                    }
                    
                } else if index + 1 == arr.count {
                    // 最后一个
                    if let tttV = lastView {
                        tmpView.snp.makeConstraints { make in
                            make.top.equalTo(tttV.snp.bottom).offset(12)
                            make.left.right.equalToSuperview()
                            make.height.equalTo(YHOtherMultipleChoiceItemView.viewH)
                            
                            make.bottom.equalToSuperview()
                        }
                    }
                } else {
                    // 中间
                    if let tttV = lastView {
                        tmpView.snp.makeConstraints { make in
                            make.top.equalTo(tttV.snp.bottom).offset(12)
                            make.left.right.equalToSuperview()
                            make.height.equalTo(YHOtherMultipleChoiceItemView.viewH)
                        }
                    }
                }
                lastView = tmpView
                
                // 对应的选项 view
                let optionView = YHSingleOptionalItemsView()
                optionView.arrCompare = dataModel
                optionView.dataModel = item
                mutilHoldView.addSubview(optionView)
                optionView.snp.makeConstraints { make in
                    make.top.left.right.equalToSuperview()
                    make.height.equalTo(YHOtherMultipleChoiceItemView.viewH)// 占位置
                }
                
                optionView.block = { model in
                    self.block?(model)
                }
                
                arrLanguageOptions.append(optionView)
                optionView.isHidden = true
            }
        }
    }
    
    func updateUI() {
        if dataModel.count > 0 {
            for (_, item) in arrLanguage.enumerated() {
                item.snp.removeConstraints()
            }
            
            for (_, item) in arrLanguageOptions.enumerated() {
                item.snp.removeConstraints()
            }
            
            noTextTipsLable.snp.removeConstraints()
            
            if dataModel.count == 3 {
                
                var hasSelectedOneFlag: Bool = false
                
                for (_, item) in dataModel.enumerated() {
                    hasSelectedOneFlag = item.select || hasSelectedOneFlag
                }
                
                var lastView: UIView?
                var offsetY: CGFloat = 12.0
                
                for (index, item) in dataModel.enumerated() {
                    
                    let multiCheckView = arrLanguage[index]
                    multiCheckView.dataModel = item
                    
                    let optionView = arrLanguageOptions[index]
                    optionView.needCheckFlag = needCheckFlag
                    
                    optionView.arrCompare = dataModel
                    optionView.dataModel = item
                    
                    if index == 0 {
                        multiCheckView.snp.remakeConstraints { make in
                            make.top.left.right.equalToSuperview()
                            make.height.equalTo(YHOtherMultipleChoiceItemView.viewH)
                        }
                        
                        if item.select {
                            // 展示选择项
                            
                            optionView.isHidden = false
                            optionView.snp.remakeConstraints { make in
                                make.top.equalTo(multiCheckView.snp.bottom).offset(8)
                                make.left.right.equalToSuperview()
                            }
                            
                            offsetY = 8
                            lastView = optionView
                            
                        } else {
                            optionView.isHidden = true
                            offsetY = 12
                            lastView = multiCheckView
                        }
                    } else if index + 1 == dataModel.count {
                        
                        if let tttView = lastView {
                            if item.select {
                                noTextTipsLable.isHidden = true
                                // 展示选择项
                                multiCheckView.snp.remakeConstraints { make in
                                    make.top.equalTo(tttView.snp.bottom).offset(offsetY)
                                    make.left.right.equalToSuperview()
                                    make.height.equalTo(YHOtherMultipleChoiceItemView.viewH)
                                }
                                
                                optionView.isHidden = false
                                optionView.snp.remakeConstraints { make in
                                    make.top.equalTo(multiCheckView.snp.bottom).offset(8)
                                    make.left.right.equalToSuperview()
                                    
                                    make.bottom.equalToSuperview()
                                }
                                
                                offsetY = 8
                                lastView = optionView
                                
                            } else {
                                optionView.isHidden = true
                                
                                if !needCheckFlag {
                                    noTextTipsLable.isHidden = true
                                    multiCheckView.snp.remakeConstraints { make in
                                        make.top.equalTo(tttView.snp.bottom).offset(offsetY)
                                        make.left.right.equalToSuperview()
                                        make.height.equalTo(YHOtherMultipleChoiceItemView.viewH)
                                        
                                        make.bottom.equalToSuperview()
                                    }
                                } else {
                                    
                                    if hasSelectedOneFlag {
                                        noTextTipsLable.isHidden = true
                                        multiCheckView.snp.remakeConstraints { make in
                                            make.top.equalTo(tttView.snp.bottom).offset(offsetY)
                                            make.left.right.equalToSuperview()
                                            make.height.equalTo(YHOtherMultipleChoiceItemView.viewH)
                                            
                                            make.bottom.equalToSuperview()
                                        }
                                        
                                    } else {
                                        noTextTipsLable.isHidden = false
                                        multiCheckView.snp.remakeConstraints { make in
                                            make.top.equalTo(tttView.snp.bottom).offset(offsetY)
                                            make.left.right.equalToSuperview()
                                            make.height.equalTo(YHOtherMultipleChoiceItemView.viewH)
                                            
//                                            make.bottom.equalToSuperview()
                                        }
                                        
                                        noTextTipsLable.snp.remakeConstraints { make in
                                            make.top.equalTo(multiCheckView.snp.bottom).offset(8)
                                            make.left.right.equalToSuperview()
                                            make.bottom.equalToSuperview().offset(-8)
                                        }
                                    }
                                }
                            }
                        }
                        
                    } else {
                        if let tttView = lastView {
                            multiCheckView.snp.remakeConstraints { make in
                                make.top.equalTo(tttView.snp.bottom).offset(offsetY)
                                make.left.right.equalToSuperview()
                                
                                make.height.equalTo(YHOtherMultipleChoiceItemView.viewH)
                            }
                            
                            if item.select {
                                // 展示选择项
                                optionView.isHidden = false
                                optionView.snp.remakeConstraints { make in
                                    make.top.equalTo(multiCheckView.snp.bottom).offset(8)
                                    make.left.right.equalToSuperview()
                                }
                                
                                offsetY = 8
                                lastView = optionView
                                
                            } else {
                                optionView.isHidden = true
                                offsetY = 12
                                lastView = multiCheckView
                            }
                        }
                    }
                }
            }
        }
    }
}
