//
//  YHOtherLanguageItemsView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHOtherMultipleChoiceItemView: UIView {
    static let viewH: CGFloat = 52.0

    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var isSelected: Bool = false {
        didSet {
            setViewSelected()
        }
    }
    
    // 数据结构
    var dataModel: LanguageDetailModel? {
        didSet {
            updateUI()
        }
    }
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.text = "中文"
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var checkImgV: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "other_multi_normal")
        view.contentMode = .scaleAspectFill
        return view
    }()
    
    typealias Block = (LanguageDetailModel?) -> Void
    var block: Block?
    
}

extension YHOtherMultipleChoiceItemView {
    func setupUI() {
        addSubview(checkImgV)
        addSubview(titleLabel)
        
        layer.cornerRadius = 3
        layer.masksToBounds = true
        
        checkImgV.snp.makeConstraints { make in
            make.left.equalTo(kMargin)
            make.width.height.equalTo(14)
            make.centerY.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(checkImgV.snp.right).offset(8)
            make.right.equalToSuperview().offset(-kMargin)
            make.centerY.equalToSuperview()
        }
        
        setViewSelected()
        
        let tap: UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(tapItem(gestureRecognizer:)))
        addGestureRecognizer(tap)
    }
    
    func setViewSelected() {
        if isSelected {
            backgroundColor = UIColor(hexString: "#EBF0F9")!
            layer.borderWidth = 1
            layer.borderColor = UIColor.brandMainColor.cgColor
            
            checkImgV.image = UIImage(named: "other_multi_check")
        } else {
            backgroundColor = .contentBkgColor
            layer.borderWidth = 0
            layer.borderColor = UIColor.clear.cgColor
            
            checkImgV.image = UIImage(named: "other_multi_normal")
        }
    }
    
    func updateUI() {
        guard let model = dataModel else {
            return
        }
        
        titleLabel.text = model.name
        isSelected = model.select
    }
    
    @objc func tapItem(gestureRecognizer: UITapGestureRecognizer) {
        guard let model = dataModel else {
            return
        }
        
        model.select = !model.select
        isSelected = model.select
        
        if !isSelected {
            for (_, ttt) in model.options.enumerated() {
                ttt.select = false
            }
        }
        self.block?(model)
    }
}
