//
//  YHOtherSingleChoiceItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHOtherSingleChoiceItemView: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var isSelected: Bool = false {
        didSet {
            setViewSelected()
        }
    }
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.text = "相关语言国家授予的学位证及成绩单相关语言国家授予的学位证及成绩单"
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var descLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.init(hex: 0x8993A2)
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.text = "(仅可尝试加分，此类文件加分以港府审批为准)"
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var checkImgV: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "other_single_normal")
        view.contentMode = .scaleAspectFill
        return view
    }()
    
    var dataModel: LanguageOptionModel? {
        didSet {
            updateUI()
        }
    }
}

extension YHOtherSingleChoiceItemView {
    func setupUI() {
        addSubview(checkImgV)
        addSubview(titleLabel)
        addSubview(descLabel)
        
        checkImgV.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.top.equalToSuperview().offset(2)
            make.width.height.equalTo(14)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalTo(checkImgV.snp.right).offset(8)
            make.right.equalToSuperview()
            make.height.greaterThanOrEqualTo(18)
        }
        
        descLabel.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(2)
            make.left.equalTo(titleLabel.snp.left)
            make.right.equalTo(titleLabel.snp.right)
            
            make.bottom.equalToSuperview()
        }
        
        setViewSelected()
    }
    
    func updateUI() {
        guard let model = dataModel else {
            return
        }
        
        titleLabel.text = model.name
        descLabel.text = model.subname
        
        isSelected = model.select
        setViewSelected()
        
        if !model.subname.isEmpty, !model.highlight.isEmpty {
            if #available(iOS 16.0, *) {
                let arr = model.subname.split(separator: model.highlight)
                if arr.count == 2 {
                    
                    let aa: ASAttributedString = .init(NSAttributedString(string: String(arr[0])), .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.init(hex: 0x8993A2)))
                    
                    let bb: ASAttributedString = .init(NSAttributedString(string: model.highlight), .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.failColor))
                    
                    let cc: ASAttributedString = .init(NSAttributedString(string: String(arr[1])), .font(UIFont.PFSC_R(ofSize: 12)), .foreground(UIColor.init(hex: 0x8993A2)))
                    
                    descLabel.attributed.text = aa + bb + cc
                    
                } else {
                    descLabel.attributed.text = nil
                    descLabel.text = model.subname
                }
            } else {
                descLabel.attributed.text = nil
                descLabel.text = model.subname
            }
            
        } else {
            
        }
    }
    
    func setViewSelected() {
        if isSelected {
            checkImgV.image = UIImage(named: "other_single_check")
        } else {
            checkImgV.image = UIImage(named: "other_single_normal")
        }
    }
}
