//
//  YHAcademicPreviewModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHAcademicPreviewModel: SmartCodable {

    var edu_correct: Int  = 0
    var qla_correct: Int  = 0
    var edu_count: Int  = 0
    var qla_count: Int  = 0
    var is_married: Int  = 0
    var is_name_same: Bool = false
    
    var edu_list: [EduListModel]?
    var qla_list: [QlaListModel]?
    
    required init() {
    }
}

class EduListModel: SmartCodable {
    
    var id: Int = -1
    var school_address_aboard: Int = -1
    var college: String = ""
    var type: String = ""
    var admission_time: String = ""
    var graduate_time: String = ""
    var professional: String = ""
    var background: String = ""
    var degree_type: String = ""
    var cert_confirm: Int = 0
    var school_address: SchoolAddressModel?
    var major_other: String = ""
    var has_bachelor_degree: Int = 0
    var college_id: Int = 0
    required init() {
        
    }
}

class QlaListModel: SmartCodable {
    var id: Int = -1
    var qualification: String = ""
    var college: String = ""
    var promulgation: Int = -1
    var college_address: SchoolAddressModel?
    var college_address_aboard: Int = -1
    
    required init() {
    }
}

class SchoolAddressModel: SmartCodable {
    var country: String = ""
    var area: [String] = []
    var foreign: String = ""
    var details: String = ""
    required init() {
    }
}
