//
//  WorkExpInfoPreviewModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

// 优才新政 - 2024优才新政
class YHWorkExpInfoPreviewNewModel: SmartCodable {
    var list: [YHWorkExpInfoPreviewDetailNewModel]?
    var why_work_time_overlap: String = ""
    var why_work_time_empty: String = ""
    required init() {
    }
}

class YHWorkExpInfoPreviewDetailNewModel: SmartCodable {
    var work_id: Int = 0
    var company_name: String = ""
    var is_ipo_company: Bool = false
    var has_company_equity: Bool = false
    var has_sales_reached: Bool = false
    var has_ipo_company_equity: Bool = false
    var has_ipo_sales_reached: Bool = false
    var enter_time: String = ""
    var leave_time: String = ""
    var work_certificate: String = ""
    var professional_level: String = ""
    var work_duty: String = ""
    var work_highlights: String = ""
    var company_location: String = ""
    var attachment_list: [WorkExpFilePreviewModel] = []
    var position_list: [YHWorkExpPositionNewModel] = []
    
    required init() {
    }
}

class YHWorkExpFilePreviewNewModel: SmartCodable {
    var file_name: String  = ""
    var file_url: String  = ""
    var file_size: Int = 0
    required init() {
    }
}

class YHWorkExpPositionNewModel: SmartCodable {
    
    var position_name: String = ""
    var wduty: String = ""
    var entry_time: String = ""
    var departure_time: String = ""
    var experience_scope: String = ""
    var experience_sub_scope: String = ""
    var is_international_work_experience: Bool = false
    var work_country: String = ""
    var work_city: String = ""
    
    required init() {
    }
    
}

// 旧优才
class YHWorkExpInfoPreviewModel: SmartCodable {
    var list: [WorkExpInfoPreviewDetailModel]?
    var count: Int = 0
    
    var has_company_consent: Int = 0 // 高才使用 在职公司是否可以提供赴港同意书 0 未知 1 是 2 否
    var consent_work_id: Int = 0 // 高才使用 可以提供赴港同意书的工作经历id
    var has_center_consent: Int = 0 // 高才使用 人才中心是否可以提供赴港同意书 0 未知 1 是 2 否
    var why_work_time_overlap: String = "" // 高才使用 关于工作时间重叠的说明
    var has_work_experience: Int = 0 // 高BC使用 是否有工作经历 0.未知 1.是 2.否
    // 高才使用 是否有工作时间重叠期 0-否 1-是
    var has_work_time_overlap: Int = 0
    required init() {
    }
}

class WorkExpInfoPreviewDetailModel: SmartCodable {
    var id: Int  = 0
    var order_id: Int  = 0
    var company_name: String  = ""
    var is_famous_enterprise: Int  = 0
    var duty: String  = ""
    var entry_time: String  = ""
    var departure_time: String  = ""
    var industry: String  = ""
    var location: AddressPreviewModel?
    var location_aboard: Int  = 0
    var professional_level: Int  = 0
    var professional_other: String  = ""
    var position: String  = ""
    var remark: String  = ""
    var old_id: Int  = 0
    var created_at: String  = ""
    var updated_at: String  = ""
    var is_show: Int = 1 // 1.保存会显示到列表上
    var deleted_at: String  = ""
    var operator_name: String  = ""
    var operator_english_name: String  = ""
    var operator_id: Int  = 0
    var work_certificate: String  = ""
    var executives_certificate: String  = ""
    var is_executives: Int  = 0
    var wduty: String  = ""
    var highlights: String  = ""
    var file: [WorkExpFilePreviewModel]?
    var not_need_upload_file: Int  = 0
    var company_member_total: Int  = 0
    var administrative_level: Int  = 0
    var company_manage_total: Int  = 0
    var top_manager_start_at: String  = ""
    var top_manager_end_at: String  = ""
    var master_of_important_project: Int  = 0
    var match_listing: Int  = 0
    var is_synthetic: Int  = 0
    var step: Int  = 0
    var create_from_appid: Int  = 0
    var update_from_appid: Int  = 0
    var international_work_experience: Int  = 0
    // var turnover: Int  = 0
    var business_nature: String  = ""
    var company_website: String  = ""
    var company_introduce: String  = ""
    var business_remark: String  = ""
    var is_project_introduction: Int  = 0
    var customer_center_id: Int  = 0
    var projects: [ProjectPreviewModel]?
    /// 公司近一年的营业额 对于高A，仅当收入类型包含 6/7/8/10 时，该字段才有效
    var turnover: String = "0"
    /// 高A使用 收入类型 1 工资薪金所得及全年一次性奖金; 2 上市公司股票期权或股权收入; 3 持股公司分红收入; 4 个体工商户/合伙企业/独资企业经营所得收入; 5
    /// 股权转让收入; 6 内地公司收入(持股50%及以上); 7 香港公司收入(持股50%及以上); 8 其他境外公司收入(持股50%及以上); 10 澳门公司收入(持股50%及以上)
    var type_of_income: [Int] = []
    /// 高A使用 收入金额
    var income: String = "0"
    /// 高才使用 是否能提供工作证明 0 未知 1 是 2 否
    var has_work_certificate: Int = 0
    /// 高才使用 职业界别
    var company_type: String = ""
    /// 高才使用 其他职业界别
    var company_type_other: String = ""
    
    required init() {
        
    }
}

class WorkExpFilePreviewModel: SmartCodable {
    var fileName: String  = ""
    var fileUrl: String  = ""
    var fileSize: Int = 0
    
    required init() {
    }
}

class AddressPreviewModel: SmartCodable {
    var area: [String] = []
    var country: String  = ""
    var details: String  = ""
    var foreign: String  = ""
    required init() {
    }
}

class ProjectPreviewModel: SmartCodable {
    var id: Int  = 0
    var order_id: Int  = 0
    var work_id: Int  = 0
    var project_name: String = ""
    var project_start_time: String = ""
    var project_end_time: String = ""
    var project_highlights: String = ""
    var update_from_appid: Int  = 0
    var create_from_appid: Int  = 0
    var customer_center_id: Int  = 0
    
    var created_at: String = ""
    var updated_at: String = ""
    var deleted_at: String = ""
    required init() {
    }
}
