//
//  YHPreviewInfoWorkSummaryView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHPreviewInfoWorkSummaryView: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var dataModel: YHWorkExpDataModel? {
        didSet {
            updateUI()
        }
    }
    
    var arrFiles: [WorkExpFilePreviewModel] = []
    var viewModel = YHBaseViewModel()
    lazy var previewFileTool: YHFilePreviewTool = {
        let tool = YHFilePreviewTool(targetVC: UIViewController.current)
        return tool
    }()
}

extension YHPreviewInfoWorkSummaryView {
    func updateUI() {
        guard let model = dataModel else { return }
        removeSubviews()
        arrFiles.removeAll()
        
        if model.data.isEmpty == false {
            let sessionView: UILabel = UILabel()
            sessionView.text = model.title
            sessionView.font = UIFont.PFSC_R(ofSize: 14)
            sessionView.textColor = UIColor.labelTextColor2
            addSubview(sessionView)
            sessionView.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.right.equalToSuperview().offset(-kMargin)
                make.left.equalToSuperview().offset(kMargin)
                make.height.equalTo(20)
            }
            
            var lastTagView: UIView = sessionView
            
            let arr = model.data as? [WorkExpFilePreviewModel] ?? []
            for(index, item) in arr.enumerated() {
                
                let label: UILabel = UILabel()
                label.text = model.title
                label.textColor = .brandMainColor
                label.font = UIFont.PFSC_R(ofSize: 14)
                label.numberOfLines = 0
                label.text = item.fileName
                label.tag = index
                addSubview(label)
                label.snp.makeConstraints { make in
                    make.top.equalTo(lastTagView.snp.bottom).offset(8)
                    make.right.equalToSuperview().offset(-kMargin)
                    make.left.equalToSuperview().offset(kMargin)
                    make.height.greaterThanOrEqualTo(20) // >=20
                }
                lastTagView = label
                
                arrFiles.append(item)
                
                label.isUserInteractionEnabled = true
                let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
                label.addGestureRecognizer(tap)
            }
            
            let tagView: UIView = UIView()
            addSubview(tagView)
            tagView.snp.makeConstraints { make in
                make.top.equalTo(lastTagView.snp.bottom).offset(18)
                make.right.equalToSuperview().offset(-kMargin)
                make.left.equalToSuperview().offset(kMargin)
                make.height.equalTo(0.5)
                
                make.bottom.equalToSuperview()
            }
        }
    }
    
    @objc func handleTap(_ gestureRecognizer: UITapGestureRecognizer) {
        guard let label = gestureRecognizer.view else { return }
        if label.tag < arrFiles.count {

            YHHUD.show(.progress(message: ""))
            self.viewModel.getPublicImageUrl(arrFiles[label.tag].fileUrl) { success, _ in
                YHHUD.hide()
                if let success = success {
                    self.previewFileTool.openXLSXRemoteFile(urlString: success, fileName: self.arrFiles[label.tag].fileName)
                }
            }
        } else {
            printLog("error: 数组越界")
        }
    }
}
